/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.entity;

import javax.annotation.Nullable;
import net.mde.duneons.init.DuneonsModEntities;
import net.mde.duneons.procedures.GuardianbeamKoghdaPuliaPopadaietVIghrokaProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class GuardianbeamProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Blocks.AIR);
    private int knockback = 0;

    public GuardianbeamProjectileEntity(EntityType<? extends GuardianbeamProjectileEntity> type, Level world) {
        super(type, world);
    }

    public GuardianbeamProjectileEntity(EntityType<? extends GuardianbeamProjectileEntity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
    }

    public GuardianbeamProjectileEntity(EntityType<? extends GuardianbeamProjectileEntity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Blocks.AIR);
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    public void playerTouch(Player entity) {
        super.playerTouch(entity);
        GuardianbeamKoghdaPuliaPopadaietVIghrokaProcedure.execute((LevelAccessor)this.level(), (Entity)entity);
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        GuardianbeamKoghdaPuliaPopadaietVIghrokaProcedure.execute((LevelAccessor)this.level(), entityHitResult.getEntity());
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static GuardianbeamProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return GuardianbeamProjectileEntity.shoot(world, entity, source, 3.0f, 2.4, 0);
    }

    public static GuardianbeamProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return GuardianbeamProjectileEntity.shoot(world, entity, source, pullingPower * 3.0f, 2.4, 0);
    }

    public static GuardianbeamProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        GuardianbeamProjectileEntity entityarrow = new GuardianbeamProjectileEntity((EntityType<? extends GuardianbeamProjectileEntity>)((EntityType)DuneonsModEntities.GUARDIANBEAM_PROJECTILE.get()), entity, world, null);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.guardian.attack")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static GuardianbeamProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        GuardianbeamProjectileEntity entityarrow = new GuardianbeamProjectileEntity((EntityType<? extends GuardianbeamProjectileEntity>)((EntityType)DuneonsModEntities.GUARDIANBEAM_PROJECTILE.get()), entity, entity.level(), null);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 6.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(2.4);
        entityarrow.setKnockback(0);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.guardian.attack")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

