/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.fluid;

import net.mde.duneons.init.DuneonsModBlocks;
import net.mde.duneons.init.DuneonsModFluidTypes;
import net.mde.duneons.init.DuneonsModFluids;
import net.mde.duneons.init.DuneonsModItems;
import net.mde.duneons.init.DuneonsModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class EndlavaFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)DuneonsModFluidTypes.ENDLAVA_TYPE.get(), () -> (Fluid)DuneonsModFluids.ENDLAVA.get(), () -> (Fluid)DuneonsModFluids.FLOWING_ENDLAVA.get()).explosionResistance(100.0f).tickRate(2).bucket(() -> (Item)DuneonsModItems.ENDLAVA_BUCKET.get()).block(() -> (LiquidBlock)DuneonsModBlocks.ENDLAVA.get());

    private EndlavaFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)DuneonsModParticleTypes.VOIDPARTICLE.get();
    }

    public static class Flowing
    extends EndlavaFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends EndlavaFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

