/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.fluid;

import net.mde.duneons.init.DuneonsModBlocks;
import net.mde.duneons.init.DuneonsModFluidTypes;
import net.mde.duneons.init.DuneonsModFluids;
import net.mde.duneons.init.DuneonsModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class EndmudFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)DuneonsModFluidTypes.ENDMUD_TYPE.get(), () -> (Fluid)DuneonsModFluids.ENDMUD.get(), () -> (Fluid)DuneonsModFluids.FLOWING_ENDMUD.get()).explosionResistance(100.0f).tickRate(14).slopeFindDistance(2).bucket(() -> (Item)DuneonsModItems.ENDMUD_BUCKET.get()).block(() -> (LiquidBlock)DuneonsModBlocks.ENDMUD.get());

    private EndmudFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.SPIT;
    }

    public static class Flowing
    extends EndmudFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends EndmudFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

