/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.init;

import net.mde.duneons.potion.ArenawaveMobEffect;
import net.mde.duneons.potion.BootsOfSwiftnessMobEffect;
import net.mde.duneons.potion.BurningMobEffect;
import net.mde.duneons.potion.BusybeesMobEffect;
import net.mde.duneons.potion.ExplodingMobEffect;
import net.mde.duneons.potion.FreezingMobEffect;
import net.mde.duneons.potion.LeechingeffectMobEffect;
import net.mde.duneons.potion.ShakeeffectMobEffect;
import net.mde.duneons.potion.StaticscareMobEffect;
import net.mde.duneons.procedures.StaticOFFProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class DuneonsModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"duneons");
    public static final DeferredHolder<MobEffect, MobEffect> BOOTS_OF_SWIFTNESS = REGISTRY.register("boots_of_swiftness", () -> new BootsOfSwiftnessMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SHAKEEFFECT = REGISTRY.register("shakeeffect", () -> new ShakeeffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BUSYBEES = REGISTRY.register("busybees", () -> new BusybeesMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> LEECHINGEFFECT = REGISTRY.register("leechingeffect", () -> new LeechingeffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EXPLODING = REGISTRY.register("exploding", () -> new ExplodingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FREEZING = REGISTRY.register("freezing", () -> new FreezingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> STATICSCARE = REGISTRY.register("staticscare", () -> new StaticscareMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BURNING = REGISTRY.register("burning", () -> new BurningMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ARENAWAVE = REGISTRY.register("arenawave", () -> new ArenawaveMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            DuneonsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            DuneonsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(STATICSCARE)) {
            StaticOFFProcedure.execute(entity);
        }
    }
}

