/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.item;

import net.mde.duneons.procedures.GauntletMobIsHitWithToolProcedure;
import net.mde.duneons.procedures.RedgauntletRightClickedInAirProcedure;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class GauntletItem
extends AxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 700;
        }

        public float getSpeed() {
            return 3.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_STONE_TOOL;
        }

        public int getEnchantmentValue() {
            return 4;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public GauntletItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)4.0f, (float)-1.0f)));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        GauntletMobIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        return retval;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        RedgauntletRightClickedInAirProcedure.execute((Entity)entity);
        return ar;
    }
}

