/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.network;

import java.util.function.Supplier;
import net.mde.duneons.DuneonsMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DuneonsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"duneons");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        DuneonsMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        DuneonsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"duneons", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"duneons", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double Index = 0.0;
        public boolean InitialItem = false;
        public boolean MusicLock = false;
        public boolean MusicLock2 = false;
        public String MusicPlay = "\"\"";
        public String MusicPlay2 = "\"\"";
        public boolean MusicReplace = false;
        public boolean MusicReplace2 = false;
        public double MusicTick = 0.0;
        public double MusicTick2 = 0.0;
        public double MusicWait = 0.0;
        public double MusicWait2 = 0.0;
        public boolean noise = false;
        public boolean SpeedStaff = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("Index", this.Index);
            nbt.putBoolean("InitialItem", this.InitialItem);
            nbt.putBoolean("MusicLock", this.MusicLock);
            nbt.putBoolean("MusicLock2", this.MusicLock2);
            nbt.putString("MusicPlay", this.MusicPlay);
            nbt.putString("MusicPlay2", this.MusicPlay2);
            nbt.putBoolean("MusicReplace", this.MusicReplace);
            nbt.putBoolean("MusicReplace2", this.MusicReplace2);
            nbt.putDouble("MusicTick", this.MusicTick);
            nbt.putDouble("MusicTick2", this.MusicTick2);
            nbt.putDouble("MusicWait", this.MusicWait);
            nbt.putDouble("MusicWait2", this.MusicWait2);
            nbt.putBoolean("noise", this.noise);
            nbt.putBoolean("SpeedStaff", this.SpeedStaff);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.Index = nbt.getDouble("Index");
            this.InitialItem = nbt.getBoolean("InitialItem");
            this.MusicLock = nbt.getBoolean("MusicLock");
            this.MusicLock2 = nbt.getBoolean("MusicLock2");
            this.MusicPlay = nbt.getString("MusicPlay");
            this.MusicPlay2 = nbt.getString("MusicPlay2");
            this.MusicReplace = nbt.getBoolean("MusicReplace");
            this.MusicReplace2 = nbt.getBoolean("MusicReplace2");
            this.MusicTick = nbt.getDouble("MusicTick");
            this.MusicTick2 = nbt.getDouble("MusicTick2");
            this.MusicWait = nbt.getDouble("MusicWait");
            this.MusicWait2 = nbt.getDouble("MusicWait2");
            this.noise = nbt.getBoolean("noise");
            this.SpeedStaff = nbt.getBoolean("SpeedStaff");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "duneons_mapvars";
        public boolean arch = false;
        public boolean bell = false;
        public boolean bell2 = false;
        public boolean Button = false;
        public boolean CactiOFF = false;
        public boolean CactiON = false;
        public boolean creeper = false;
        public boolean Fiery = false;
        public boolean fiery2 = false;
        public boolean mines = false;
        public boolean pumpkin = false;
        public boolean pumpkins = false;
        public boolean redstone_on = false;
        public double soggyinlock = 0.0;
        public double SoggyLock = 0.0;
        public double SoulBar = 0.0;
        public boolean SwampLock = false;
        public boolean SwampUnlock = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.arch = nbt.getBoolean("arch");
            this.bell = nbt.getBoolean("bell");
            this.bell2 = nbt.getBoolean("bell2");
            this.Button = nbt.getBoolean("Button");
            this.CactiOFF = nbt.getBoolean("CactiOFF");
            this.CactiON = nbt.getBoolean("CactiON");
            this.creeper = nbt.getBoolean("creeper");
            this.Fiery = nbt.getBoolean("Fiery");
            this.fiery2 = nbt.getBoolean("fiery2");
            this.mines = nbt.getBoolean("mines");
            this.pumpkin = nbt.getBoolean("pumpkin");
            this.pumpkins = nbt.getBoolean("pumpkins");
            this.redstone_on = nbt.getBoolean("redstone_on");
            this.soggyinlock = nbt.getDouble("soggyinlock");
            this.SoggyLock = nbt.getDouble("SoggyLock");
            this.SoulBar = nbt.getDouble("SoulBar");
            this.SwampLock = nbt.getBoolean("SwampLock");
            this.SwampUnlock = nbt.getBoolean("SwampUnlock");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("arch", this.arch);
            nbt.putBoolean("bell", this.bell);
            nbt.putBoolean("bell2", this.bell2);
            nbt.putBoolean("Button", this.Button);
            nbt.putBoolean("CactiOFF", this.CactiOFF);
            nbt.putBoolean("CactiON", this.CactiON);
            nbt.putBoolean("creeper", this.creeper);
            nbt.putBoolean("Fiery", this.Fiery);
            nbt.putBoolean("fiery2", this.fiery2);
            nbt.putBoolean("mines", this.mines);
            nbt.putBoolean("pumpkin", this.pumpkin);
            nbt.putBoolean("pumpkins", this.pumpkins);
            nbt.putBoolean("redstone_on", this.redstone_on);
            nbt.putDouble("soggyinlock", this.soggyinlock);
            nbt.putDouble("SoggyLock", this.SoggyLock);
            nbt.putDouble("SoulBar", this.SoulBar);
            nbt.putBoolean("SwampLock", this.SwampLock);
            nbt.putBoolean("SwampUnlock", this.SwampUnlock);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "duneons_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.Index = original.Index;
            clone.InitialItem = original.InitialItem;
            clone.MusicLock = original.MusicLock;
            clone.MusicLock2 = original.MusicLock2;
            clone.MusicPlay = original.MusicPlay;
            clone.MusicPlay2 = original.MusicPlay2;
            clone.MusicReplace = original.MusicReplace;
            clone.MusicReplace2 = original.MusicReplace2;
            clone.MusicTick = original.MusicTick;
            clone.MusicTick2 = original.MusicTick2;
            clone.MusicWait = original.MusicWait;
            clone.MusicWait2 = original.MusicWait2;
            if (!event.isWasDeath()) {
                clone.noise = original.noise;
                clone.SpeedStaff = original.SpeedStaff;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

