/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.network;

import java.util.HashMap;
import net.mde.duneons.DuneonsMod;
import net.mde.duneons.procedures.CloseuiProcedure;
import net.mde.duneons.procedures.GotofrozenProcedure;
import net.mde.duneons.procedures.GotohighlandProcedure;
import net.mde.duneons.procedures.GotojungleProcedure;
import net.mde.duneons.procedures.StonetablemapingOnBlockRightClickedProcedure;
import net.mde.duneons.procedures.TohiddenDepthsProcedure;
import net.mde.duneons.world.inventory.Infostructires2Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record Infostructires2ButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<Infostructires2ButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"duneons", (String)"infostructires_2_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, Infostructires2ButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new Infostructires2ButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<Infostructires2ButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(Infostructires2ButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                Infostructires2ButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = Infostructires2Menu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CloseuiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            StonetablemapingOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GotojungleProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GotofrozenProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GotohighlandProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            TohiddenDepthsProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DuneonsMod.addNetworkMessage(TYPE, STREAM_CODEC, Infostructires2ButtonMessage::handleData);
    }
}

