/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.network;

import java.util.HashMap;
import net.mde.duneons.DuneonsMod;
import net.mde.duneons.procedures.DarkinfoProcedure;
import net.mde.duneons.procedures.ErrorSoundProcedure;
import net.mde.duneons.procedures.GotocactiProcedure;
import net.mde.duneons.procedures.GotocreeperProcedure;
import net.mde.duneons.procedures.GotodesertProcedure;
import net.mde.duneons.procedures.GotooverworldProcedure;
import net.mde.duneons.procedures.GotopumpProcedure;
import net.mde.duneons.procedures.SwamppageProcedure;
import net.mde.duneons.procedures.ToMinesProcedure;
import net.mde.duneons.procedures.TofiertProcedure;
import net.mde.duneons.world.inventory.InfostructiresMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record InfostructiresButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InfostructiresButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"duneons", (String)"infostructires2_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, InfostructiresButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new InfostructiresButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<InfostructiresButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(InfostructiresButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                InfostructiresButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = InfostructiresMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ToMinesProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            GotocreeperProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            SwamppageProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GotopumpProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GotocactiProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            GotodesertProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            TofiertProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            DarkinfoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            ErrorSoundProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            GotooverworldProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DuneonsMod.addNetworkMessage(TYPE, STREAM_CODEC, InfostructiresButtonMessage::handleData);
    }
}

