/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.manager;

import com.github.tartaricacid.simplebedrockmodel.SimpleBedrockModel;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.AbstractBedrockEntityModel;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;

public class BedrockEntityModelSet<T extends AbstractBedrockEntityModel<? extends Entity>>
extends SimplePreparableReloadListener<Void> {
    private Map<ResourceLocation, T> models = ImmutableMap.of();
    private Map<ResourceLocation, Function<InputStream, T>> knowLocations = Maps.newHashMap();

    void addModel(ResourceLocation location, Function<InputStream, T> function) {
        this.knowLocations.put(location, function);
    }

    void immutableKnowLocations() {
        this.knowLocations = ImmutableMap.copyOf(this.knowLocations);
    }

    protected Void prepare(ResourceManager manager, ProfilerFiller filler) {
        this.models = Maps.newHashMap();
        this.knowLocations.keySet().forEach(location -> {
            ResourceLocation path = new ResourceLocation(location.m_135827_(), "models/" + location.m_135815_() + ".json");
            Function<InputStream, T> modelFunction = this.knowLocations.get(location);
            manager.m_213713_(path).ifPresentOrElse(model -> {
                SimpleBedrockModel.LOGGER.info("Loading bedrock model file: {}", (Object)path);
                try (InputStream stream = model.m_215507_();){
                    this.models.put((ResourceLocation)location, (T)((AbstractBedrockEntityModel)modelFunction.apply(stream)));
                }
                catch (IOException e) {
                    SimpleBedrockModel.LOGGER.error("Failed to load model file: {}", (Object)path, (Object)e);
                }
            }, () -> SimpleBedrockModel.LOGGER.error("Not found model file: {}", (Object)path));
        });
        return null;
    }

    protected void apply(Void unused, ResourceManager manager, ProfilerFiller filler) {
        this.models = ImmutableMap.copyOf(this.models);
    }

    Map<ResourceLocation, ? extends AbstractBedrockEntityModel<? extends Entity>> getModels() {
        return this.models;
    }
}

