/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.SkinGuiNumber;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractModelGui<T extends LivingEntity, E extends IModelInfo>
extends Screen {
    public static final Button.OnPress NO_PRESS = b -> {};
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select.png");
    private static final ResourceLocation SIDE = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select_side.png");
    private static final ResourceLocation EMPTY_ICON = new ResourceLocation("touhou_little_maid", "textures/gui/empty_model_pack_icon.png");
    private static final SimpleTexture EMPTY_ICON_TEXTURE = new SimpleTexture(EMPTY_ICON);
    protected final T entity;
    private final SkinGuiNumber<E> guiNumber;
    private final List<CustomModelPack<E>> modelPackList;
    private EditBox searchBox;
    private String searchText = "";
    private List<E> filteredModelList = null;
    private boolean isSearchMode = false;
    private List<E> allModelsList = null;

    public AbstractModelGui(T entity, List<CustomModelPack<E>> listPack) {
        super((Component)Component.m_237113_((String)"Custom Model GUI"));
        this.entity = entity;
        this.modelPackList = listPack;
        this.guiNumber = new SkinGuiNumber(this.modelPackList);
        this.setPageIndex(Mth.m_14045_((int)this.getPageIndex(), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
        this.setPackIndex(Mth.m_14045_((int)this.getPackIndex(), (int)0, (int)(this.guiNumber.getPackSize() - 1)));
        this.setRowIndex(Mth.m_14045_((int)this.getRowIndex(), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex())));
        this.allModelsList = Lists.newArrayList();
        for (CustomModelPack<E> pack : this.modelPackList) {
            this.allModelsList.addAll(pack.getModelList());
        }
    }

    protected abstract void drawLeftEntity(GuiGraphics var1, int var2, int var3, float var4, float var5);

    protected abstract void drawRightEntity(GuiGraphics var1, int var2, int var3, E var4);

    protected abstract void openDetailsGui(T var1, E var2);

    protected abstract void notifyModelChange(T var1, E var2);

    protected abstract void addModelCustomTips(E var1, List<Component> var2);

    protected abstract int getPackIndex();

    protected abstract void setPackIndex(int var1);

    protected abstract int getRowIndex();

    protected abstract void setRowIndex(int var1);

    protected abstract int getPageIndex();

    protected abstract void setPageIndex(int var1);

    public void m_7856_() {
        this.m_169413_();
        this.updateFilteredModelList();
        int startX = this.f_96543_ / 2 + 50;
        int startY = this.f_96544_ / 2;
        for (int index = 0; index < 7; ++index) {
            this.addTabButton(startX, startY, index);
        }
        this.m_142416_((GuiEventListener)new ImageButton(startX + 122, startY - 97, 21, 17, 58, 201, 18, BG, b -> this.onClickCloseButton()));
        this.addPageButton(startX, startY);
        this.addModelButton(startX, startY);
        this.addScrollButton(startX, startY);
        MutableComponent enableCache = Component.m_237115_((String)"gui.touhou_little_maid.skin.enable_cache");
        int checkBoxWidth = this.f_96547_.m_92852_((FormattedText)enableCache) + 20;
        int xOffset = (startX - 128) / 2 - checkBoxWidth / 2;
        this.m_142416_((GuiEventListener)new Checkbox(xOffset, startY - 101, 20, 20, (Component)enableCache, (Boolean)MiscConfig.MODEL_ICON_CACHE.get()){

            public void m_5691_() {
                super.m_5691_();
                MiscConfig.MODEL_ICON_CACHE.set((Object)this.m_93840_());
            }
        });
        int searchBoxWidth = 216;
        int searchBoxX = startX - 96;
        int searchBoxY = startY + 101;
        this.searchBox = new EditBox(this.f_96547_, searchBoxX, searchBoxY, searchBoxWidth, 18, (Component)Component.m_237115_((String)"gui.touhou_little_maid.skin.search"));
        this.searchBox.m_94199_(48);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94202_(-1);
        this.searchBox.m_94144_(this.searchText);
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.touhou_little_maid.skin.search.hint").m_130940_(ChatFormatting.DARK_GRAY));
        this.searchBox.m_94151_(this::onSearchTextChanged);
        this.searchBox.m_94194_(this.isSearchMode);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.addSearchTabButton(startX, startY);
    }

    private void addModelButton(int startX, int startY) {
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex >= displayList.size()) {
            return;
        }
        int toIndex = Math.min(fromIndex + 55, displayList.size());
        for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
            this.m_142416_((GuiEventListener)new ImageButton(startX + offsetX - 8, startY + offsetY - 26, 15, 24, 41, 201, 24, BG, this.onModelButtonClick(modelItem)));
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void addScrollButton(int startX, int startY) {
        ImageButton upButton = new ImageButton(startX - 128 + 253, startY - 73, 14, 10, 24, 15, 10, SIDE, b -> {
            int row = Mth.m_14045_((int)(this.getRowIndex() - 1), (int)0, (int)this.getDisplayRowSize());
            if (row != this.getRowIndex()) {
                this.setRowIndex(row);
                this.m_7856_();
            }
        });
        ImageButton downButton = new ImageButton(startX - 128 + 253, startY - 73 + 156, 14, 10, 38, 15, 10, SIDE, b -> {
            int row = Mth.m_14045_((int)(this.getRowIndex() + 1), (int)0, (int)this.getDisplayRowSize());
            if (row != this.getRowIndex()) {
                this.setRowIndex(row);
                this.m_7856_();
            }
        });
        this.m_142416_((GuiEventListener)upButton);
        this.m_142416_((GuiEventListener)downButton);
    }

    private Button.OnPress onModelButtonClick(E modelItem) {
        return button -> {
            if (AbstractModelGui.m_96638_()) {
                this.openDetailsGui(this.entity, modelItem);
            } else {
                this.notifyModelChange(this.entity, modelItem);
            }
        };
    }

    private void addPageButton(int startX, int startY) {
        Button prePage = Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(Mth.m_14045_((int)(this.getPageIndex() - 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.m_7856_();
        }).m_252794_(startX - 119, startY - 101).m_253046_(20, 20).m_253136_();
        Button nextPage = Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(Mth.m_14045_((int)(this.getPageIndex() + 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.m_7856_();
        }).m_252794_(startX + 99, startY - 101).m_253046_(20, 20).m_253136_();
        if (this.getPageIndex() == 0) {
            prePage.f_93623_ = false;
        }
        if (this.getPageIndex() == this.guiNumber.getPageSize() - 1) {
            nextPage.f_93623_ = false;
        }
        this.m_142416_((GuiEventListener)prePage);
        this.m_142416_((GuiEventListener)nextPage);
    }

    private void addTabButton(int startX, int startY, int index) {
        if (index == this.guiNumber.getTabIndex(this.getPackIndex()) && !this.isSearchMode) {
            this.m_142416_((GuiEventListener)new ImageButton(startX - 98 + 28 * index, startY - 108, 28, 31, 116, 224, 0, BG, NO_PRESS));
            return;
        }
        if (index < this.guiNumber.getTabSize(this.getPackIndex())) {
            this.m_142416_((GuiEventListener)new ImageButtonWithId(index, startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG, b -> {
                ImageButtonWithId imageButton = (ImageButtonWithId)b;
                int packIndex = this.guiNumber.tabToPackIndex(imageButton.getIndex(), this.getPageIndex());
                this.setRowIndex(0);
                this.setPackIndex(packIndex);
                this.isSearchMode = false;
                this.searchText = "";
                this.m_7856_();
            }));
        }
    }

    private void addSearchTabButton(int startX, int startY) {
        int searchTabX = startX - 121;
        int searchTabY = startY + 100;
        if (this.isSearchMode) {
            this.m_142416_((GuiEventListener)new ImageButton(searchTabX, searchTabY - 4, 24, 26, 145, 194, 0, BG, NO_PRESS));
        } else {
            this.m_142416_((GuiEventListener)new ImageButton(searchTabX, searchTabY, 24, 21, 145, 220, 0, BG, b -> {
                this.setRowIndex(0);
                this.isSearchMode = true;
                this.m_7856_();
            }));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280168_().m_252880_(0.0f, 0.0f, -100.0f);
        int middleX = this.f_96543_ / 2 + 50;
        int middleY = this.f_96544_ / 2;
        this.m_280273_(graphics);
        graphics.m_280218_(BG, middleX - 128, middleY - 80, 0, 0, 256, 180);
        graphics.m_280218_(SIDE, middleX - 128 + 250, middleY - 80, 0, 0, 24, 180);
        this.drawScrollSide(graphics, middleX, middleY);
        this.drawButton(graphics, mouseX, mouseY, partialTicks);
        this.drawTabIcon(graphics, middleX, middleY);
        double scale = this.getMinecraft().m_91268_().m_85449_();
        RenderSystem.enableScissor((int)0, (int)0, (int)((int)((double)(middleX - 128) * scale)), (int)((int)((double)this.f_96544_ * scale)));
        this.drawLeftEntity(graphics, middleX, middleY, mouseX, mouseY);
        RenderSystem.disableScissor();
        this.drawEntity(graphics, middleX, middleY);
        this.drawTooltips(graphics, mouseX, mouseY, middleX, middleY);
    }

    private void drawButton(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Renderable button : this.f_169369_) {
            button.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void drawScrollSide(GuiGraphics graphics, int middleX, int middleY) {
        if (this.canScrollCurrentList()) {
            graphics.m_280218_(SIDE, middleX - 128 + 254, middleY - 61 + (int)(127.0f * this.getCurrentScrollPosition()), 24, 0, 12, 15);
        } else {
            graphics.m_280218_(SIDE, middleX - 128 + 254, middleY - 61 + (int)(127.0f * this.getCurrentScrollPosition()), 36, 0, 12, 15);
        }
    }

    private void drawTabIcon(GuiGraphics graphics, int middleX, int middleY) {
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            CustomModelPack<E> pack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            ResourceLocation icon = pack.getIcon();
            if (icon == null) continue;
            AbstractTexture iconTexture = Minecraft.m_91087_().f_90987_.m_174786_(icon, (AbstractTexture)EMPTY_ICON_TEXTURE);
            if (EMPTY_ICON_TEXTURE.equals(iconTexture)) {
                icon = EMPTY_ICON;
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(pack, icon);
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                graphics.m_280163_(icon, middleX - 92 + 28 * index, middleY - 98, 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
            int time = this.getTickTime() / pack.getIconDelay();
            int iconIndex = time % pack.getIconAspectRatio();
            graphics.m_280163_(icon, middleX - 92 + 28 * index, middleY - 98, 0.0f, (float)(iconIndex * 16), 16, 16, 16, 16 * pack.getIconAspectRatio());
        }
    }

    public void m_86600_() {
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(CustomModelPack<E> pack, ResourceLocation icon) {
        AbstractTexture iconText = this.getMinecraft().m_91097_().m_118506_(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            SizeTexture sizeTexture = (SizeTexture)iconText;
            int width = sizeTexture.getWidth();
            if (width >= (height = sizeTexture.getHeight())) {
                pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                pack.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                pack.setIconAspectRatio(height / width);
            }
        } else {
            pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    private void drawEntity(GuiGraphics graphics, int middleX, int middleY) {
        if (!this.isSearchMode) {
            CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
            this.drawPackInfoText(graphics, pack, middleX, middleY);
        }
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -38;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex >= displayList.size()) {
            return;
        }
        int toIndex = Math.min(fromIndex + 55, displayList.size());
        for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
            this.drawRightEntity(graphics, middleX + offsetX, middleY + offsetY, modelItem);
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void drawPackInfoText(GuiGraphics graphics, CustomModelPack<E> pack, int middleX, int middleY) {
        int offsetY = -80;
        int sideMiddleX = (middleX - 128) / 2;
        MutableComponent packName = ParseI18n.parse(pack.getPackName());
        List packSplitName = this.f_96547_.m_92865_().m_92414_((FormattedText)packName, middleX - 128 - 20, Style.f_131099_);
        for (FormattedText properties : packSplitName) {
            graphics.m_280137_(this.f_96547_, properties.getString(), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        for (Component str : ParseI18n.parse(pack.getDescription())) {
            List split = this.f_96547_.m_92865_().m_92414_((FormattedText)str, middleX - 128 - 20, Style.f_131099_);
            for (FormattedText properties : split) {
                graphics.m_280137_(this.f_96547_, properties.getString(), sideMiddleX, middleY + (offsetY += 10), ChatFormatting.DARK_GRAY.m_126665_().intValue());
            }
        }
        if (!pack.getAuthor().isEmpty()) {
            for (List textList : Lists.partition(pack.getAuthor(), (int)2)) {
                graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)textList.toString()).m_130940_(ChatFormatting.GOLD), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
            }
        }
        if (pack.getVersion() != null) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237110_((String)"gui.touhou_little_maid.skin.text.version", (Object[])new Object[]{pack.getVersion()}).m_130940_(ChatFormatting.DARK_AQUA), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        if (pack.getDate() != null) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237110_((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{pack.getDate()}).m_130940_(ChatFormatting.GREEN), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        graphics.m_280137_(this.f_96547_, String.format("%s/%s", this.getPageIndex() + 1, this.guiNumber.getPageSize()), middleX, middleY - 118, 0xFFFFFF);
    }

    private void drawTooltips(GuiGraphics graphics, int mouseX, int mouseY, int middleX, int middleY) {
        boolean yInRange;
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex < displayList.size()) {
            int toIndex = Math.min(fromIndex + 55, displayList.size());
            for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
                boolean isyInRange;
                boolean isxInRange = middleX + offsetX - 8 < mouseX && mouseX < middleX + offsetX + 7;
                boolean bl = isyInRange = middleY + offsetY - 23 < mouseY && mouseY < middleY + offsetY + 1;
                if (isxInRange && isyInRange) {
                    ArrayList<String> str = new ArrayList<String>();
                    str.add(modelItem.getName());
                    str.addAll(modelItem.getDescription());
                    List<Component> tooltips = ParseI18n.parse(str);
                    this.addModelCustomTips(modelItem, tooltips);
                    if (!modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.encrypt}") && !modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.normal}")) {
                        tooltips.add((Component)Component.m_237115_((String)"gui.touhou_little_maid.skin.tooltips.show_details").m_130940_(ChatFormatting.DARK_PURPLE));
                    }
                    if (this.getMinecraft().f_91066_.f_92125_) {
                        tooltips.add((Component)Component.m_237113_((String)modelItem.getModelId().toString()).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                    if (this.isSearchMode) {
                        CustomModelPack<IModelInfo> modelPack = this.findPackForModel(modelItem);
                        if (modelPack != null) {
                            tooltips.add((Component)ParseI18n.parse(modelPack.getPackName()).m_130940_(ChatFormatting.BLUE));
                        }
                    } else {
                        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
                        tooltips.add((Component)ParseI18n.parse(pack.getPackName()).m_130940_(ChatFormatting.BLUE));
                    }
                    graphics.m_280666_(this.f_96547_, tooltips, mouseX, mouseY);
                }
                if ((offsetX += 20) <= 105) continue;
                offsetX = -100;
                offsetY += 30;
            }
        }
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            boolean isyInRange;
            boolean isxInRange = middleX - 98 + 28 * index < mouseX && mouseX < middleX - 98 + 28 * index + 28;
            boolean bl = isyInRange = middleY - 108 < mouseY && mouseY < middleY - 108 + 31;
            if (!isxInRange || !isyInRange) continue;
            CustomModelPack<E> hoverPack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            graphics.m_280557_(this.f_96547_, (Component)ParseI18n.parse(hoverPack.getPackName()), mouseX, mouseY);
        }
        boolean xInRange = middleX + 122 < mouseX && mouseX < middleX + 143;
        boolean bl = yInRange = middleY - 97 < mouseY && mouseY < middleY - 80;
        if (xInRange && yInRange) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.skin.button.close"), mouseX, mouseY);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            int row;
            int index = 0;
            if (delta > 0.0) {
                index = 1;
            }
            if (delta < 0.0) {
                index = -1;
            }
            if ((row = Mth.m_14045_((int)(this.getRowIndex() - index), (int)0, (int)this.getDisplayRowSize())) != this.getRowIndex()) {
                this.setRowIndex(row);
                this.m_7856_();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchBox != null && this.searchBox.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.searchBox);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_93696_() && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_93696_() && this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private void onSearchTextChanged(String text) {
        if (!this.searchText.equals(text)) {
            this.searchText = text;
            this.setRowIndex(0);
            this.m_7856_();
        }
    }

    private void updateFilteredModelList() {
        if (this.isSearchMode) {
            if (StringUtils.isBlank((CharSequence)this.searchText)) {
                this.filteredModelList = this.allModelsList;
            } else {
                String lowerSearchText = this.searchText.toLowerCase(Locale.ENGLISH).trim();
                this.filteredModelList = this.allModelsList.stream().filter(model -> this.filterKeyWord(model, lowerSearchText)).collect(Collectors.toList());
            }
        } else {
            this.filteredModelList = null;
        }
    }

    private boolean filterKeyWord(E model, String keyword) {
        String modelName = ParseI18n.getI18nValue(model.getName());
        if (modelName.toLowerCase(Locale.ENGLISH).contains(keyword)) {
            return true;
        }
        for (String desc : model.getDescription()) {
            String descText = ParseI18n.getI18nValue(desc);
            if (!descText.toLowerCase(Locale.ENGLISH).contains(keyword)) continue;
            return true;
        }
        String modelId = model.getModelId().toString().toLowerCase(Locale.ENGLISH);
        return modelId.contains(keyword);
    }

    private List<E> getDisplayModelList() {
        if (this.isSearchMode) {
            return Objects.requireNonNullElseGet(this.filteredModelList, () -> Objects.requireNonNullElse(this.allModelsList, Collections.emptyList()));
        }
        return this.modelPackList.get(this.getPackIndex()).getModelList();
    }

    private int getDisplayRowSize() {
        List<E> displayList = this.getDisplayModelList();
        if (displayList == null || displayList.isEmpty()) {
            return 0;
        }
        int row = (displayList.size() - 1) / 11 + 1;
        return Math.max(row - 5, 0);
    }

    private CustomModelPack<E> findPackForModel(E model) {
        for (CustomModelPack<E> pack : this.modelPackList) {
            if (!pack.getModelList().contains(model)) continue;
            return pack;
        }
        return null;
    }

    private boolean canScrollCurrentList() {
        if (this.isSearchMode) {
            List<E> displayList = this.getDisplayModelList();
            int modelSize = displayList.size() - 11 * this.getRowIndex();
            return modelSize > 55;
        }
        return this.guiNumber.canScroll(this.getPackIndex(), this.getRowIndex());
    }

    private float getCurrentScrollPosition() {
        if (this.isSearchMode) {
            List<E> displayList = this.getDisplayModelList();
            if (displayList.isEmpty()) {
                return 0.0f;
            }
            int totalRows = (displayList.size() - 1) / 11;
            int maxScroll = Math.max(totalRows - 4, 0);
            if (maxScroll == 0) {
                return 0.0f;
            }
            return Mth.m_14036_((float)((float)((double)this.getRowIndex() * (1.0 / (double)maxScroll))), (float)0.0f, (float)1.0f);
        }
        return this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex());
    }

    protected void onClickCloseButton() {
        this.m_7379_();
    }
}

