/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;

public class MaidBreathAirStopTask
extends Behavior<EntityMaid> {
    public MaidBreathAirStopTask() {
        super((Map)ImmutableMap.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        if (!maid.getSwimManager().isGoingToBreath()) {
            return false;
        }
        if (maid.m_20146_() >= 290) {
            return true;
        }
        if (MobEffectUtil.m_19588_((LivingEntity)maid)) {
            return true;
        }
        return this.hasDrownBauble(maid);
    }

    protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
        maid.getSwimManager().setGoingToBreath(false);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
    }

    private boolean hasDrownBauble(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        for (int i = 0; i < maidBauble.getSlots(); ++i) {
            if (!maidBauble.getStackInSlot(i).m_150930_((Item)InitItems.DROWN_PROTECT_BAUBLE.get())) continue;
            return true;
        }
        return false;
    }
}

