/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.data;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaidTaskDataMaps {
    private static final String TAG_NAME = "MaidTaskDataMaps";
    private final Reference2ObjectMap<TaskDataKey<?>, Optional<?>> dataMaps = new Reference2ObjectOpenHashMap();

    @Nullable
    public <T> T getData(TaskDataKey<T> dataKey) {
        Optional optional = (Optional)this.dataMaps.get(dataKey);
        if (optional != null && optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public <T> T getOrCreateData(TaskDataKey<T> dataKey, T defaultValue) {
        T data;
        if (this.dataMaps.containsKey(dataKey) && (data = this.getData(dataKey)) != null) {
            return data;
        }
        this.dataMaps.put(dataKey, Optional.of(defaultValue));
        return defaultValue;
    }

    public <T> void setData(TaskDataKey<?> dataKey, T value) {
        this.dataMaps.put(dataKey, Optional.of(value));
    }

    public void writeSaveData(CompoundTag entityTag) {
        CompoundTag dataTags = this.readOrCreateTag(entityTag);
        this.dataMaps.forEach((key, value) -> {
            TaskDataKey dataKey = key;
            value.ifPresent(data -> {
                CompoundTag saveData = dataKey.writeSaveData(data);
                dataTags.m_128365_(key.getKey().toString(), (Tag)saveData);
            });
        });
    }

    public void readSaveData(CompoundTag entityTag) {
        this.dataMaps.clear();
        CompoundTag dataTags = this.readOrCreateTag(entityTag);
        for (String key : dataTags.m_128431_()) {
            TaskDataKey dataKey = TaskDataRegister.getValue(new ResourceLocation(key));
            if (dataKey == null) continue;
            CompoundTag tag = dataTags.m_128469_(key);
            this.dataMaps.put(dataKey, Optional.of(dataKey.readSaveData(tag)));
        }
    }

    public CompoundTag getUpdateTag() {
        CompoundTag taskTags = new CompoundTag();
        this.dataMaps.forEach((key, value) -> {
            TaskDataKey dataKey = key;
            value.ifPresent(data -> {
                CompoundTag syncData = dataKey.writeSyncData(data);
                taskTags.m_128365_(key.getKey().toString(), (Tag)syncData);
            });
        });
        return taskTags;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readFromServer(CompoundTag taskTags) {
        this.dataMaps.clear();
        for (String key : taskTags.m_128431_()) {
            TaskDataKey dataKey = TaskDataRegister.getValue(new ResourceLocation(key));
            if (dataKey == null) continue;
            CompoundTag tag = taskTags.m_128469_(key);
            this.dataMaps.put(dataKey, Optional.of(dataKey.readSyncData(tag)));
        }
    }

    @NotNull
    private CompoundTag readOrCreateTag(CompoundTag entityTag) {
        if (entityTag.m_128441_(TAG_NAME)) {
            return entityTag.m_128469_(TAG_NAME);
        }
        CompoundTag dataTags = new CompoundTag();
        entityTag.m_128365_(TAG_NAME, (Tag)dataTags);
        return dataTags;
    }
}

