/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;

public final class SchedulePos {
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private BlockPos workPos;
    private BlockPos idlePos;
    private BlockPos sleepPos;
    private ResourceLocation dimension;
    private boolean configured = false;

    public SchedulePos(BlockPos workPos, BlockPos idlePos, BlockPos sleepPos, ResourceLocation dimension) {
        this.workPos = workPos;
        this.idlePos = idlePos;
        this.sleepPos = sleepPos;
        this.dimension = dimension;
    }

    public SchedulePos(BlockPos workPos, BlockPos idlePos, ResourceLocation dimension) {
        this(workPos, idlePos, idlePos, dimension);
    }

    public SchedulePos(BlockPos workPos, ResourceLocation dimension) {
        this(workPos, workPos, dimension);
    }

    public void setWorkPos(BlockPos workPos) {
        this.workPos = workPos;
    }

    public void setIdlePos(BlockPos idlePos) {
        this.idlePos = idlePos;
    }

    public void setSleepPos(BlockPos sleepPos) {
        this.sleepPos = sleepPos;
    }

    public void setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    public void tick(EntityMaid maid) {
        if (maid.f_19797_ % 40 == 0) {
            int minTeleportDistance;
            this.restrictTo(maid);
            if (maid.m_21533_()) {
                return;
            }
            if (!maid.canBrainMoving()) {
                return;
            }
            double distanceSqr = maid.m_21534_().m_123331_((Vec3i)maid.m_20183_());
            if (distanceSqr > (double)((minTeleportDistance = (int)maid.m_21535_() + 4) * minTeleportDistance) && !this.sameWithRestrictCenter(maid)) {
                this.teleport(maid);
            } else {
                BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)maid.m_21534_(), (float)0.7f, (int)3);
            }
        }
    }

    public void save(CompoundTag compound) {
        CompoundTag data = new CompoundTag();
        data.m_128365_("Work", (Tag)NbtUtils.m_129224_((BlockPos)this.workPos));
        data.m_128365_("Idle", (Tag)NbtUtils.m_129224_((BlockPos)this.idlePos));
        data.m_128365_("Sleep", (Tag)NbtUtils.m_129224_((BlockPos)this.sleepPos));
        data.m_128359_("Dimension", this.dimension.toString());
        data.m_128379_("Configured", this.configured);
        compound.m_128365_("MaidSchedulePos", (Tag)data);
    }

    public void load(CompoundTag compound, EntityMaid maid) {
        if (compound.m_128425_("MaidSchedulePos", 10)) {
            CompoundTag data = compound.m_128469_("MaidSchedulePos");
            this.workPos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("Work"));
            this.idlePos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("Idle"));
            this.sleepPos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("Sleep"));
            this.dimension = new ResourceLocation(data.m_128461_("Dimension"));
            this.configured = data.m_128471_("Configured");
            this.restrictTo(maid);
        }
    }

    public void restrictTo(EntityMaid maid) {
        if (!maid.isHomeModeEnable()) {
            return;
        }
        Activity activity = maid.getScheduleDetail();
        if (activity == Activity.f_37980_) {
            maid.m_21446_(this.workPos, (Integer)MaidConfig.MAID_WORK_RANGE.get());
            return;
        }
        if (activity == Activity.f_37979_) {
            maid.m_21446_(this.idlePos, (Integer)MaidConfig.MAID_IDLE_RANGE.get());
            return;
        }
        if (activity == Activity.f_37982_) {
            maid.m_21446_(this.sleepPos, (Integer)MaidConfig.MAID_SLEEP_RANGE.get());
        }
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public BlockPos getWorkPos() {
        return this.workPos;
    }

    public BlockPos getIdlePos() {
        return this.idlePos;
    }

    public BlockPos getSleepPos() {
        return this.sleepPos;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public void clear(EntityMaid maid) {
        this.idlePos = this.workPos;
        this.sleepPos = this.workPos;
        this.configured = false;
        this.dimension = maid.f_19853_.m_46472_().m_135782_();
        this.restrictTo(maid);
    }

    public void setHomeModeEnable(EntityMaid maid, BlockPos pos) {
        if (!this.configured) {
            this.workPos = pos;
            this.idlePos = pos;
            this.sleepPos = pos;
            this.dimension = maid.f_19853_.m_46472_().m_135782_();
        }
        this.restrictTo(maid);
    }

    @Nullable
    public BlockPos getNearestPos(EntityMaid maid) {
        if (this.configured) {
            BlockPos pos = this.workPos;
            double workDistance = maid.m_20183_().m_123331_((Vec3i)this.workPos);
            double idleDistance = maid.m_20183_().m_123331_((Vec3i)this.idlePos);
            double sleepDistance = maid.m_20183_().m_123331_((Vec3i)this.sleepPos);
            if (workDistance > idleDistance) {
                pos = this.idlePos;
                workDistance = idleDistance;
            }
            if (workDistance > sleepDistance) {
                pos = this.sleepPos;
            }
            return pos;
        }
        return null;
    }

    private boolean sameWithRestrictCenter(EntityMaid maid) {
        BlockPos restrictCenter = maid.m_21534_();
        return maid.m_6274_().m_21952_(MemoryModuleType.f_26370_).filter(walkTarget -> walkTarget.m_26420_().m_6675_().equals((Object)restrictCenter)).isPresent();
    }

    private void teleport(EntityMaid maid) {
        for (int i = 0; i < 10; ++i) {
            if (!TeleportHelper.teleportToRestrictCenter(maid)) continue;
            return;
        }
    }
}

