/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.ITriggerSlotChange;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeMenuType;

public class CraftingTableBackpackContainer
extends MaidMainContainer {
    public static final MenuType<CraftingTableBackpackContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new CraftingTableBackpackContainer(windowId, inv, data.readInt()));
    private final CraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer resultSlots = new ResultContainer();
    private final ContainerLevelAccess access;
    private final ResultSlot resultSlot;
    private final Player player;

    public CraftingTableBackpackContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        this.player = inventory.f_35978_;
        this.access = ContainerLevelAccess.m_39289_((Level)this.getMaid().f_19853_, (BlockPos)this.getMaid().m_20183_());
        this.resultSlot = new ResultSlot(this.player, this.craftSlots, (Container)this.resultSlots, 0, 229, 119);
        this.m_38897_((Slot)this.resultSlot);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.craftSlots, j + i * 3, 152 + j * 18, 101 + i * 18));
            }
        }
    }

    public void m_6199_(Container container) {
        this.access.m_39292_((level, blockPos) -> this.slotChangedCraftingGrid(this, (Level)level, this.player, this.craftSlots, this.resultSlots));
    }

    @Override
    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(player, (Container)this.craftSlots));
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultSlots && super.m_5882_(stack, slot);
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack1 = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack2 = slot.m_7993_();
            stack1 = stack2.m_41777_();
            if (index == this.resultSlot.f_40219_) {
                this.access.m_39292_((level, blockPos) -> stack2.m_41720_().m_7836_(stack2, level, player));
                if (!this.m_38903_(stack2, 0, 36, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack2, stack1);
            } else if (index < this.resultSlot.f_40219_ ? (index < 36 ? !this.m_38903_(stack2, 36, this.resultSlot.f_40219_, false) : !this.m_38903_(stack2, 0, 36, true)) : !this.m_38903_(stack2, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (stack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack2.m_41613_() == stack1.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack2);
            if (slot instanceof ITriggerSlotChange) {
                ITriggerSlotChange slotChange = (ITriggerSlotChange)slot;
                slotChange.onShiftTakeoff(player, stack1);
            }
            if (index == this.resultSlot.f_40219_) {
                player.m_36176_(stack2, false);
            }
        }
        return stack1;
    }

    @Override
    protected void addBackpackInv(Inventory inventory) {
        int i;
        for (i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new MaidMainContainer.BackpackSlot(this.maid, 6 + i, 143 + 18 * i, 57));
        }
        for (i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new MaidMainContainer.BackpackSlot(this.maid, 12 + i, 143 + 18 * i, 75));
        }
    }

    private void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, Player player, CraftingContainer container, ResultContainer result) {
        if (!level.f_46443_ && level.m_7654_() != null) {
            ItemStack stack2;
            CraftingRecipe recipe;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack1 = ItemStack.f_41583_;
            Optional optional = level.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)container, level);
            if (optional.isPresent() && result.m_40135_(level, serverPlayer, (Recipe)(recipe = (CraftingRecipe)optional.get())) && (stack2 = recipe.m_5874_((Container)container, level.m_9598_())).m_246617_(level.m_246046_())) {
                stack1 = stack2;
            }
            result.m_6836_(0, stack1);
            menu.m_150404_(0, stack1);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), this.resultSlot.f_40219_, stack1));
        }
    }
}

