/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAndItemTransformEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.item.AbstractStoreMaidItem;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFilm
extends AbstractStoreMaidItem {
    private static final String ID_TAG = "id";

    public ItemFilm() {
        super(new Item.Properties().m_41487_(1));
    }

    public static ItemStack maidToFilm(EntityMaid maid) {
        ItemStack film = ((Item)InitItems.FILM.get()).m_7968_();
        CompoundTag filmTag = new CompoundTag();
        CompoundTag maidTag = new CompoundTag();
        maid.setHomeModeEnable(false);
        maid.m_20240_(maidTag);
        ItemFilm.removeMaidSomeData(maidTag);
        maidTag.m_128359_(ID_TAG, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)InitEntities.MAID.get()))).toString());
        MaidAndItemTransformEvent.ToItem event = new MaidAndItemTransformEvent.ToItem(maid, film, maidTag);
        MinecraftForge.EVENT_BUS.post((Event)event);
        filmTag.m_128365_("MaidInfo", (Tag)maidTag);
        film.m_41751_(filmTag);
        return film;
    }

    public static void filmToMaid(ItemStack film, Level worldIn, BlockPos pos, Player player) {
        ResourceLocation maidId;
        CompoundTag data = ItemFilm.getMaidData(film);
        ResourceLocation entityId = new ResourceLocation(data.m_128461_(ID_TAG));
        if (entityId.equals((Object)(maidId = ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)InitEntities.MAID.get()))))) {
            EntityMaid maid = new EntityMaid(worldIn);
            MaidAndItemTransformEvent.ToMaid event = new MaidAndItemTransformEvent.ToMaid(maid, film, data);
            MinecraftForge.EVENT_BUS.post((Event)event);
            maid.m_7378_(data);
            maid.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            if (!worldIn.f_46443_) {
                worldIn.m_7967_((Entity)maid);
                NetworkHandler.sendToNearby((Entity)maid, new SpawnParticleMessage(maid.m_19879_(), SpawnParticleMessage.Type.EXPLOSION));
                worldIn.m_5594_(null, pos, (SoundEvent)InitSounds.ALTAR_CRAFT.get(), SoundSource.VOICE, 1.0f, 1.0f);
            }
            film.m_41774_(1);
            return;
        }
        if (!worldIn.f_46443_) {
            player.m_213846_((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.film.no_data.desc"));
        }
    }

    private static void removeMaidSomeData(CompoundTag nbt) {
        nbt.m_128473_("MaidBackpackType");
        nbt.m_128473_("MaidInventory");
        nbt.m_128473_("MaidBaubleInventory");
        nbt.m_128473_("MaidExperience");
        nbt.m_128473_("ArmorItems");
        nbt.m_128473_("HandItems");
        nbt.m_128473_("Leash");
        nbt.m_128473_("Health");
        nbt.m_128473_("HurtTime");
        nbt.m_128473_("DeathTime");
        nbt.m_128473_("HurtByTimestamp");
        nbt.m_128473_("Pos");
        nbt.m_128473_("Motion");
        nbt.m_128473_("FallDistance");
        nbt.m_128473_("Fire");
        nbt.m_128473_("Air");
        nbt.m_128473_("TicksFrozen");
        nbt.m_128473_("HasVisualFire");
        nbt.m_128473_("Passengers");
        nbt.m_128473_("ActiveEffects");
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!ItemFilm.hasMaidData(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.film.no_data.desc").m_130940_(ChatFormatting.DARK_RED));
        }
    }
}

