/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class MaidModelMessage {
    private final int id;
    private final ResourceLocation modelId;

    public MaidModelMessage(int id, ResourceLocation modelId) {
        this.id = id;
        this.modelId = modelId;
    }

    public static void encode(MaidModelMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
        buf.m_130085_(message.modelId);
    }

    public static MaidModelMessage decode(FriendlyByteBuf buf) {
        return new MaidModelMessage(buf.readInt(), buf.m_130281_());
    }

    public static void handle(MaidModelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.id);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    if (sender.m_7500_() || ((Boolean)MaidConfig.MAID_CHANGE_MODEL.get()).booleanValue()) {
                        maid.setIsYsmModel(false);
                        maid.setModelId(message.modelId.toString());
                        InitTrigger.MAID_EVENT.trigger(sender, "change_maid_model");
                    } else {
                        sender.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.change_model.disabled"));
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

