/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.tts;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public final class SupportLanguage {
    public static final List<String> SUPPORTED_LANGUAGES = List.of("en_us", "zh_cn", "ja_jp", "ru_ru", "vi_vn", "ko_kr", "es_es", "pt_br", "fr_fr", "de_de", "tr_tr");

    public static String findNext(String language) {
        int index = SUPPORTED_LANGUAGES.indexOf(language);
        if (index == -1) {
            return SUPPORTED_LANGUAGES.get(0);
        }
        return SUPPORTED_LANGUAGES.get(++index % SUPPORTED_LANGUAGES.size());
    }

    public static String findPrev(String language) {
        int index = SUPPORTED_LANGUAGES.indexOf(language);
        if (index == -1) {
            return SUPPORTED_LANGUAGES.get(0);
        }
        if (--index < 0) {
            index = SUPPORTED_LANGUAGES.size() - 1;
        }
        return SUPPORTED_LANGUAGES.get(index);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Component getLanguageName(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return Component.m_237113_((String)"English (US)");
        }
        LanguageManager languageManager = Minecraft.m_91087_().m_91102_();
        LanguageInfo info = languageManager.m_118976_(language);
        if (info != null) {
            return info.m_264517_();
        }
        return Component.m_237113_((String)"English (US)");
    }
}

