/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.AbstractModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.MaidModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ModelDetailsButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class MaidModelDetailsGui
extends AbstractModelDetailsGui<EntityMaid, MaidModelInfo> {
    private static final ItemStack MAIN_HAND_SWORD = Items.f_42388_.m_7968_();
    private static final ItemStack OFF_HAND_SHIELD = Items.f_42740_.m_7968_();
    private static final ItemStack ARMOR_ITEM = Items.f_42476_.m_7968_();
    private EntityChair chair;
    private volatile boolean isEnableWalk = false;

    public MaidModelDetailsGui(EntityMaid sourceEntity, MaidModelInfo modelInfo) {
        super(sourceEntity, (EntityMaid)((EntityType)InitEntities.MAID.get()).m_20615_(sourceEntity.m_9236_()), modelInfo);
        ((EntityMaid)this.guiEntity).setModelId(modelInfo.getModelId().toString());
        ((EntityMaid)this.guiEntity).m_6853_(true);
        ((EntityMaid)this.guiEntity).f_20885_ = 0.0f;
        ((EntityMaid)this.guiEntity).f_20886_ = 0.0f;
        this.initChair();
    }

    private void initChair() {
        if (Minecraft.m_91087_().f_91073_ != null) {
            this.chair = (EntityChair)((EntityType)InitEntities.CHAIR.get()).m_20615_((Level)Minecraft.m_91087_().f_91073_);
            if (this.chair != null) {
                this.chair.setModelId("touhou_little_maid:low_stool");
            }
        }
    }

    @Override
    protected void applyReturnButtonLogic() {
        Minecraft.m_91087_().m_91152_((Screen)new MaidModelGui((EntityMaid)this.sourceEntity));
    }

    @Override
    protected void initSideButton() {
        ModelDetailsButton begButton = new ModelDetailsButton(2, 17, "gui.touhou_little_maid.skin_details.beg", isStateTriggered -> ((EntityMaid)this.guiEntity).setBegging((boolean)isStateTriggered));
        ModelDetailsButton walkButton = new ModelDetailsButton(2, 30, "gui.touhou_little_maid.skin_details.walk", isStateTriggered -> {
            this.isEnableWalk = isStateTriggered;
        });
        ModelDetailsButton sitButton = new ModelDetailsButton(2, 43, "gui.touhou_little_maid.skin_details.sit", isStateTriggered -> ((EntityMaid)this.guiEntity).m_21837_((boolean)isStateTriggered));
        ModelDetailsButton rideButton = new ModelDetailsButton(2, 56, "gui.touhou_little_maid.skin_details.ride", this::applyRideButtonLogic);
        ModelDetailsButton helmetButton = new ModelDetailsButton(2, 69, "gui.touhou_little_maid.skin_details.helmet", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlot.HEAD, (boolean)isStateTriggered));
        ModelDetailsButton chestPlateButton = new ModelDetailsButton(2, 82, "gui.touhou_little_maid.skin_details.chest_plate", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlot.CHEST, (boolean)isStateTriggered));
        ModelDetailsButton leggingsButton = new ModelDetailsButton(2, 95, "gui.touhou_little_maid.skin_details.leggings", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlot.LEGS, (boolean)isStateTriggered));
        ModelDetailsButton bootsButton = new ModelDetailsButton(2, 108, "gui.touhou_little_maid.skin_details.boots", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlot.FEET, (boolean)isStateTriggered));
        ModelDetailsButton mainHandButton = new ModelDetailsButton(2, 121, "gui.touhou_little_maid.skin_details.main_hand", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlot.MAINHAND, (boolean)isStateTriggered));
        ModelDetailsButton offHandButton = new ModelDetailsButton(2, 134, "gui.touhou_little_maid.skin_details.off_hand", isStateTriggered -> this.applyEquipmentButtonLogic(EquipmentSlot.OFFHAND, (boolean)isStateTriggered));
        this.m_142416_((GuiEventListener)begButton);
        this.m_142416_((GuiEventListener)walkButton);
        this.m_142416_((GuiEventListener)sitButton);
        this.m_142416_((GuiEventListener)rideButton);
        this.m_142416_((GuiEventListener)helmetButton);
        this.m_142416_((GuiEventListener)chestPlateButton);
        this.m_142416_((GuiEventListener)leggingsButton);
        this.m_142416_((GuiEventListener)bootsButton);
        this.m_142416_((GuiEventListener)mainHandButton);
        this.m_142416_((GuiEventListener)offHandButton);
    }

    public void m_86600_() {
        ++((EntityMaid)this.guiEntity).f_19797_;
        float speed = this.isEnableWalk ? 0.5f : 0.0f;
        ((EntityMaid)this.guiEntity).f_267362_.m_267566_(speed, 0.4f);
    }

    @Override
    protected void renderExtraEntity(EntityRenderDispatcher manager, PoseStack matrix, MultiBufferSource.BufferSource bufferIn) {
        if (((EntityMaid)this.guiEntity).m_20159_() && this.chair != null) {
            manager.m_114384_((Entity)this.chair, 0.0, -0.95, 0.0, 0.0f, 1.0f, matrix, (MultiBufferSource)bufferIn, 0xF000F0);
        }
    }

    private void applyRideButtonLogic(boolean isStateTriggered) {
        if (isStateTriggered && this.chair != null) {
            ((EntityMaid)this.guiEntity).m_7998_((Entity)this.chair, true);
        } else {
            ((EntityMaid)this.guiEntity).m_6038_();
        }
    }

    private void applyEquipmentButtonLogic(EquipmentSlot slot, boolean isStateTriggered) {
        if (isStateTriggered) {
            if (slot == EquipmentSlot.MAINHAND) {
                ((EntityMaid)this.guiEntity).m_8061_(slot, MAIN_HAND_SWORD);
            } else if (slot == EquipmentSlot.OFFHAND) {
                ((EntityMaid)this.guiEntity).m_8061_(slot, OFF_HAND_SHIELD);
            } else {
                ((EntityMaid)this.guiEntity).m_8061_(slot, ARMOR_ITEM);
            }
        } else {
            ((EntityMaid)this.guiEntity).m_8061_(slot, ItemStack.f_41583_);
        }
    }
}

