/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.datagen.LanguageGenerator;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;

public class FavorabilityAdvancement {
    public static void generate(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement root = FavorabilityAdvancement.make((ItemLike)InitItems.BOOKSHELF.get(), "maid_sit_joy").m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_sit_joy")).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).save(saver, FavorabilityAdvancement.id("favorability/maid_sit_joy"), existingFileHelper);
        FavorabilityAdvancement.generateFavorability(saver, existingFileHelper, root);
        FavorabilityAdvancement.generateJoy(saver, existingFileHelper, root);
    }

    private static void generateJoy(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper, Advancement root) {
        Advancement joy = FavorabilityAdvancement.make((ItemLike)InitItems.PICNIC_BASKET.get(), "maid_picnic_eat").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_picnic_eat")).save(saver, FavorabilityAdvancement.id("favorability/maid_picnic_eat"), existingFileHelper);
        Advancement gomoku = FavorabilityAdvancement.makeGoal((ItemLike)InitItems.GOMOKU.get(), "win_gomoku").m_138398_(joy).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("win_gomoku")).save(saver, FavorabilityAdvancement.id("favorability/win_gomoku"), existingFileHelper);
        Advancement cchess = FavorabilityAdvancement.makeGoal((ItemLike)InitItems.CCHESS.get(), "win_cchess").m_138398_(gomoku).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("win_cchess")).save(saver, FavorabilityAdvancement.id("favorability/win_cchess"), existingFileHelper);
        FavorabilityAdvancement.makeGoal((ItemLike)InitItems.WCHESS.get(), "win_wchess").m_138398_(cchess).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("win_wchess")).save(saver, FavorabilityAdvancement.id("favorability/win_wchess"), existingFileHelper);
        FavorabilityAdvancement.make((ItemLike)InitItems.MAID_BED.get(), "maid_sleep").m_138398_(joy).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_sleep")).save(saver, FavorabilityAdvancement.id("favorability/maid_sleep"), existingFileHelper);
    }

    private static void generateFavorability(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper, Advancement root) {
        Advancement increased = FavorabilityAdvancement.make((ItemLike)InitItems.FAVORABILITY_TOOL_ADD.get(), "favorability_increased").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("favorability_increased")).save(saver, FavorabilityAdvancement.id("favorability/favorability_increased"), existingFileHelper);
        FavorabilityAdvancement.makeGoal((ItemLike)InitItems.FAVORABILITY_TOOL_FULL.get(), "favorability_increased_max").m_138398_(increased).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("favorability_increased_max")).save(saver, FavorabilityAdvancement.id("favorability/favorability_increased_max"), existingFileHelper);
    }

    private static Advancement.Builder make(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.favorability.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.favorability.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false);
    }

    private static Advancement.Builder makeGoal(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.favorability.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.favorability.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.GOAL, true, true, false);
    }

    private static ResourceLocation id(String id) {
        return new ResourceLocation("touhou_little_maid", id);
    }
}

