/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidFarmPlantTask
extends Behavior<EntityMaid> {
    private final IFarmTask task;

    public MaidFarmPlantTask(IFarmTask task) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT));
        this.task = task;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        Brain<EntityMaid> brain = owner.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            if (owner.m_20238_(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0)) {
                Optional walkTarget = brain.m_21952_(MemoryModuleType.f_26370_);
                if (walkTarget.isEmpty() || !((WalkTarget)walkTarget.get()).m_26420_().m_7024_().equals((Object)targetV3d)) {
                    brain.m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected void start(ServerLevel world, EntityMaid maid, long gameTimeIn) {
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockPos basePos = posWrapper.m_6675_();
            BlockPos cropPos = basePos.m_7494_();
            BlockState cropState = world.m_8055_(cropPos);
            if (maid.canDestroyBlock(cropPos) && this.task.canHarvest(maid, cropPos, cropState)) {
                this.task.harvest(maid, cropPos, cropState);
                maid.m_6674_(InteractionHand.MAIN_HAND);
                maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                LivingEntity patt3109$temp = maid.m_269323_();
                if (patt3109$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt3109$temp;
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_farm");
                }
            }
            CombinedInvWrapper availableInv = maid.getAvailableInv(true);
            List<Integer> slots = ItemsUtil.getFilterStackSlots((IItemHandler)availableInv, this.task::isSeed);
            if (!slots.isEmpty()) {
                for (int slot : slots) {
                    ItemStack seed = availableInv.getStackInSlot(slot);
                    BlockState baseState = world.m_8055_(basePos);
                    if (!this.task.canPlant(maid, basePos, baseState, seed)) continue;
                    ItemStack remain = this.task.plant(maid, basePos, baseState, seed);
                    availableInv.setStackInSlot(slot, remain);
                    maid.m_6674_(InteractionHand.MAIN_HAND);
                    maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                    maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                    LivingEntity patt4178$temp = maid.m_269323_();
                    if (patt4178$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt4178$temp;
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_farm");
                    }
                    return;
                }
            }
        });
    }
}

