/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MaidStartSnowballAttacking<E extends Mob>
extends Behavior<E> {
    private final Predicate<E> canAttackPredicate;
    private final Function<E, Optional<? extends LivingEntity>> targetFinderFunction;

    public MaidStartSnowballAttacking(Predicate<E> predicate, Function<E, Optional<? extends LivingEntity>> function) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED));
        this.canAttackPredicate = predicate;
        this.targetFinderFunction = function;
    }

    public MaidStartSnowballAttacking(Function<E, Optional<? extends LivingEntity>> function) {
        this(f -> true, function);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E owner) {
        if (!this.canAttackPredicate.test(owner)) {
            return false;
        }
        Optional<? extends LivingEntity> optional = this.targetFinderFunction.apply(owner);
        return optional.isPresent() && optional.get().m_6084_();
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        this.targetFinderFunction.apply(pEntity).ifPresent(entity -> this.setAttackTarget(pEntity, (LivingEntity)entity));
    }

    private void setAttackTarget(E owner, LivingEntity entity) {
        owner.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)entity);
        owner.m_6274_().m_21936_(MemoryModuleType.f_26326_);
    }
}

