/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;

public class MaidGameRecordManager {
    private static final String GAME_SKILL_TAG = "MaidGameSkillData";
    private static final String GOMOKU = "Gomoku";
    private static final byte NONE = 0;
    private static final byte WIN = 1;
    private static final byte LOSE = 2;
    private final EntityMaid maid;

    public MaidGameRecordManager(EntityMaid maid) {
        this.maid = maid;
    }

    void defineSynchedData() {
        this.maid.m_20088_().m_135372_(EntityMaid.GAME_SKILL, (Object)new CompoundTag());
        this.maid.m_20088_().m_135372_(EntityMaid.GAME_STATUE, (Object)0);
    }

    void addAdditionalSaveData(CompoundTag compound) {
        compound.m_128365_(GAME_SKILL_TAG, (Tag)this.getGameSkill());
    }

    void readAdditionalSaveData(CompoundTag compound) {
        if (compound.m_128425_(GAME_SKILL_TAG, 10)) {
            this.setGameSkill(compound.m_128469_(GAME_SKILL_TAG));
        }
    }

    void tick() {
        if (!(this.maid.m_20202_() instanceof EntitySit) && this.getGameStatue() != 0) {
            this.resetStatue();
        }
    }

    private CompoundTag getGameSkill() {
        return (CompoundTag)this.maid.m_20088_().m_135370_(EntityMaid.GAME_SKILL);
    }

    private void setGameSkill(CompoundTag gameSkill) {
        this.maid.m_20088_().m_276349_(EntityMaid.GAME_SKILL, (Object)gameSkill, true);
    }

    private byte getGameStatue() {
        return (Byte)this.maid.m_20088_().m_135370_(EntityMaid.GAME_STATUE);
    }

    private void setGameStatue(byte gameStatue) {
        this.maid.m_20088_().m_135381_(EntityMaid.GAME_STATUE, (Object)gameStatue);
    }

    public int getGomokuWinCount() {
        CompoundTag gameSkill = this.getGameSkill();
        if (gameSkill.m_128425_(GOMOKU, 3)) {
            return gameSkill.m_128451_(GOMOKU);
        }
        return 0;
    }

    public void increaseGomokuWinCount() {
        CompoundTag gameSkill = this.getGameSkill();
        if (gameSkill.m_128425_(GOMOKU, 3)) {
            gameSkill.m_128405_(GOMOKU, gameSkill.m_128451_(GOMOKU) + 1);
        } else {
            gameSkill.m_128405_(GOMOKU, 1);
        }
        this.setGameSkill(gameSkill);
    }

    public boolean isWin() {
        return this.getGameStatue() == 1;
    }

    public boolean isLost() {
        return this.getGameStatue() == 2;
    }

    public void markStatue(boolean isWin) {
        this.setGameStatue(isWin ? (byte)1 : 2);
        if (isWin) {
            this.maid.m_5496_((SoundEvent)InitSounds.GAME_WIN.get(), 1.0f, 1.0f);
        } else {
            this.maid.m_5496_((SoundEvent)InitSounds.GAME_LOST.get(), 1.0f, 1.0f);
        }
    }

    public void resetStatue() {
        this.setGameStatue((byte)0);
    }
}

