/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmPlantTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmSurroundingMoveTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TaskMelon
implements IFarmTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "melon");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42575_.m_7968_();
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        return false;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidFarmSurroundingMoveTask maidFarmSurroundingMoveTask = new MaidFarmSurroundingMoveTask(this, 0.6f);
        MaidFarmPlantTask maidFarmPlantTask = new MaidFarmPlantTask(this);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)maidFarmSurroundingMoveTask)), Pair.of((Object)6, (Object)((Object)maidFarmPlantTask))});
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        Block block = cropState.m_60734_();
        if (block == Blocks.f_50186_ || block == Blocks.f_50133_) {
            Block stem = block == Blocks.f_50186_ ? Blocks.f_50188_ : Blocks.f_50187_;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState offsetState = maid.f_19853_.m_8055_(cropPos.m_121945_(direction));
                if (!offsetState.m_60713_(stem)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        ItemStack mainHandItem = maid.m_21205_();
        if (cropState.m_60713_(Blocks.f_50186_) && EnchantmentHelper.m_272262_((ItemStack)mainHandItem)) {
            if (maid.destroyBlock(cropPos, false)) {
                mainHandItem.m_41622_(1, (LivingEntity)maid, e -> e.m_21190_(InteractionHand.MAIN_HAND));
                Block.m_49840_((Level)maid.f_19853_, (BlockPos)cropPos, (ItemStack)Items.f_42028_.m_7968_());
            }
        } else {
            maid.destroyBlock(cropPos);
        }
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        return false;
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        return seed;
    }

    @Override
    public double getCloseEnoughDist() {
        return 1.5;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_silk_touch", (Object)Predicates.alwaysTrue()));
    }
}

