/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.ISpecialCropHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.crop.SpecialCropManager;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.CropBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class TaskNormalFarm
implements IFarmTask {
    private static final ResourceLocation NAME = new ResourceLocation("touhou_little_maid", "farm");

    @Override
    public ResourceLocation getUid() {
        return NAME;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42387_.m_7968_();
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        ItemNameBlockItem blockNamedItem;
        Block block;
        Item item = stack.m_41720_();
        ISpecialCropHandler handler = SpecialCropManager.getItemSeedHandlers().get(item);
        if (handler != null) {
            return handler.isSeed(stack);
        }
        if (item instanceof ItemNameBlockItem && (block = (blockNamedItem = (ItemNameBlockItem)item).m_40614_()) instanceof IPlantable) {
            IPlantable plant = (IPlantable)block;
            return plant.getPlantType((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_) == PlantType.CROP && plant.getPlant((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_).m_60734_() != Blocks.f_50016_;
        }
        return false;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        CropBlock crop;
        Block block = cropState.m_60734_();
        ISpecialCropHandler handler = SpecialCropManager.getBlockCropHandlers().get(block);
        if (handler != null) {
            return handler.canHarvest(maid, cropPos, cropState);
        }
        return block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(cropState);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        boolean isDestroyMode = maid.m_21205_().m_41720_() instanceof HoeItem;
        Block cropBlock = cropState.m_60734_();
        ISpecialCropHandler handler = SpecialCropManager.getBlockCropHandlers().get(cropBlock);
        if (handler != null) {
            handler.harvest(maid, cropPos, cropState, isDestroyMode);
            return;
        }
        if (isDestroyMode) {
            maid.destroyBlock(cropPos);
        } else if (cropBlock instanceof CropBlockAccessor) {
            CropBlockAccessor crop = (CropBlockAccessor)cropBlock;
            BlockEntity blockEntity = cropState.m_155947_() ? maid.f_19853_.m_7702_(cropPos) : null;
            maid.dropResourcesToMaidInv(cropState, maid.f_19853_, cropPos, blockEntity, maid, maid.m_21205_());
            maid.f_19853_.m_46796_(2001, cropPos, Block.m_49956_((BlockState)cropState));
            if (cropState.m_61138_((Property)crop.tlmAgeProperty())) {
                try {
                    cropState = (BlockState)cropState.m_263224_((Property)crop.tlmAgeProperty(), (Comparable)Integer.valueOf(0));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            maid.f_19853_.m_7731_(cropPos, cropState, 3);
            maid.f_19853_.m_142346_((Entity)maid, GameEvent.f_157792_, cropPos);
        }
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        ItemNameBlockItem blockNamedItem;
        Block block;
        ISpecialCropHandler handler = SpecialCropManager.getBlockCropHandlers().get(baseState.m_60734_());
        if (handler != null) {
            return handler.canPlant(maid, basePos, baseState, seed);
        }
        BlockState aboveState = maid.f_19853_.m_8055_(basePos.m_7494_());
        if (!aboveState.m_247087_() || aboveState.m_278721_()) {
            return false;
        }
        Item item = seed.m_41720_();
        if (item instanceof ItemNameBlockItem && (block = (blockNamedItem = (ItemNameBlockItem)item).m_40614_()) instanceof IPlantable) {
            IPlantable plant = (IPlantable)block;
            return baseState.canSustainPlant((BlockGetter)maid.f_19853_, basePos, Direction.UP, plant);
        }
        return false;
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        ItemNameBlockItem blockNamedItem;
        Block block;
        Item item = seed.m_41720_();
        ISpecialCropHandler handler = SpecialCropManager.getItemSeedHandlers().get(item);
        if (handler != null) {
            return handler.plant(maid, basePos, baseState, seed);
        }
        if (item instanceof ItemNameBlockItem && (block = (blockNamedItem = (ItemNameBlockItem)item).m_40614_()) instanceof IPlantable) {
            maid.placeItemBlock(basePos.m_7494_(), seed);
        }
        return seed;
    }
}

