/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.block.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.block.multiblock.MultiBlockManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ItemHakureiGohei
extends ProjectileWeaponItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ItemHakureiGohei() {
        super(new Item.Properties().m_41503_(300).setNoRepair());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 4.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -2.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public static boolean isGohei(ItemStack stack) {
        return stack.m_41720_() instanceof ItemHakureiGohei;
    }

    public Predicate<ItemStack> m_6437_() {
        return Predicates.alwaysTrue();
    }

    public int m_6615_() {
        return 15;
    }

    public int m_8105_(ItemStack stack) {
        return 500;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43724_() == InteractionHand.MAIN_HAND) {
            List<IMultiBlock> multiBlockList = MultiBlockManager.getMultiBlockList();
            BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            Direction direction = context.m_43719_();
            for (IMultiBlock multiBlock : multiBlockList) {
                if (!multiBlock.isCoreBlock(blockState) || !multiBlock.directionIsSuitable(direction)) continue;
                if (world instanceof ServerLevel) {
                    StructureTemplate template;
                    ServerLevel serverLevel = (ServerLevel)world;
                    BlockPos posStart = pos.m_121955_((Vec3i)multiBlock.getCenterPos(direction));
                    if (multiBlock.isMatch(world, posStart, direction, template = multiBlock.getTemplate(serverLevel, direction))) {
                        multiBlock.build(world, posStart, direction, template);
                        serverLevel.m_5594_(null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.5f, 1.0f);
                        Player player = context.m_43723_();
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            InitTrigger.MAID_EVENT.trigger(serverPlayer, "build_altar");
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(2, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44960_ || enchantment == Enchantments.f_44959_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }
}

