/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MaidAnimationMessage {
    public static final int NONE = 0;
    public static final int PICK_UP_SNOWBALL = 1;
    public static final int SWF_AIM = 2;
    public static final int SWF_RELOAD = 3;
    public static final int SWF_FIRE = 4;
    private final int maidId;
    private final int animationId;

    public MaidAnimationMessage(int maidId, int animationId) {
        this.maidId = maidId;
        this.animationId = animationId;
    }

    public static MaidAnimationMessage pickUpSnowball(EntityMaid maid) {
        maid.animationId = 1;
        maid.animationRecordTime = System.currentTimeMillis();
        return new MaidAnimationMessage(maid.m_19879_(), 1);
    }

    public static void encode(MaidAnimationMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.maidId);
        buf.writeInt(message.animationId);
    }

    public static MaidAnimationMessage decode(FriendlyByteBuf buf) {
        return new MaidAnimationMessage(buf.readInt(), buf.readInt());
    }

    public static void handle(MaidAnimationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> MaidAnimationMessage.handle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(MaidAnimationMessage message) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(message.maidId);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            maid.animationId = message.animationId;
            maid.animationRecordTime = System.currentTimeMillis();
            maid.shouldReset = true;
        }
    }
}

