/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTaskEnableEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.TaskConfigContainer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class MaidTaskMessage {
    private final int id;
    private final ResourceLocation uid;

    public MaidTaskMessage(int id, ResourceLocation uid) {
        this.id = id;
        this.uid = uid;
    }

    public static void encode(MaidTaskMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
        buf.m_130085_(message.uid);
    }

    public static MaidTaskMessage decode(FriendlyByteBuf buf) {
        return new MaidTaskMessage(buf.readInt(), buf.m_130281_());
    }

    public static void handle(MaidTaskMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.id);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    LivingEntity patt2661$temp;
                    IMaidTask task = TaskManager.findTask(message.uid).orElse(TaskManager.getIdleTask());
                    if (task != TaskManager.getIdleTask() && MinecraftForge.EVENT_BUS.post((Event)new MaidTaskEnableEvent(task, maid))) {
                        return;
                    }
                    if (!task.isEnable(maid)) {
                        return;
                    }
                    maid.setTask(task);
                    if (!TaskManager.getIdleTask().equals(task) && (patt2661$temp = maid.m_269323_()) instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt2661$temp;
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, "switch_task");
                    }
                    if (sender.f_36096_ instanceof TaskConfigContainer) {
                        maid.openMaidGui((Player)sender, 1);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

