/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class OpenChairGuiMessage {
    private final int id;

    public OpenChairGuiMessage(int id) {
        this.id = id;
    }

    public static void encode(OpenChairGuiMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
    }

    public static OpenChairGuiMessage decode(FriendlyByteBuf buf) {
        return new OpenChairGuiMessage(buf.readInt());
    }

    public static void handle(OpenChairGuiMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> OpenChairGuiMessage.handleOpenGui(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOpenGui(OpenChairGuiMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity e = mc.f_91073_.m_6815_(message.id);
        if (mc.f_91074_ != null && mc.f_91074_.m_6084_() && e instanceof EntityChair) {
            EntityChair chair = (EntityChair)e;
            if (e.m_6084_()) {
                CacheIconManager.openChairModelGui(chair);
            }
        }
    }
}

