/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;

public final class SystemAppDataUtil {
    public static Path getAppDataDir(String appName) {
        if (StringUtils.isBlank((CharSequence)appName)) {
            throw new IllegalArgumentException("Application name cannot be null or empty");
        }
        Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        if (Platform.isAndroid()) {
            String androidData = System.getenv("EXTERNAL_STORAGE");
            if (androidData != null && !androidData.trim().isEmpty()) {
                return Paths.get(androidData, new String[0]).resolve("Android").resolve("data").resolve(appName);
            }
            return userHome.resolve("Android").resolve("data").resolve(appName);
        }
        if (Platform.isWindows()) {
            String appData = System.getenv("APPDATA");
            if (appData != null && !appData.trim().isEmpty()) {
                return Paths.get(appData, new String[0]).resolve(appName);
            }
            return userHome.resolve("AppData").resolve("Roaming").resolve(appName);
        }
        if (Platform.isMac()) {
            return userHome.resolve("Library").resolve("Application Support").resolve(appName);
        }
        String xdgData = System.getenv("XDG_DATA_HOME");
        if (xdgData != null && !xdgData.trim().isEmpty()) {
            return Paths.get(xdgData, new String[0]).resolve(appName);
        }
        return userHome.resolve(".local").resolve("share").resolve(appName);
    }

    public static Path getAndCreateAppDataDir(String appName) throws IOException {
        Path dir = SystemAppDataUtil.getAppDataDir(appName);
        if (!dir.toFile().isDirectory()) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        return dir;
    }
}

