/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.tts;

import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SystemServices;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import org.apache.commons.lang3.tuple.Pair;

public interface TTSSystemServices
extends SystemServices {
    public void play(String var1, TTSConfig var2, @Nullable ResponseCallback<byte[]> var3);

    default public boolean isClient() {
        return Dist.CLIENT.isClient();
    }

    default public void writeToNetwork(String message, TTSConfig config, FriendlyByteBuf buffer) {
        buffer.writeUtf(message);
        buffer.writeUtf(config.model());
        buffer.writeUtf(config.language());
    }

    default public Pair<String, TTSConfig> readFromNetwork(FriendlyByteBuf buffer) {
        String message = buffer.readUtf();
        String model = buffer.readUtf();
        String language = buffer.readUtf();
        return Pair.of((Object)message, (Object)new TTSConfig(model, language));
    }
}

