/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenBeaconGuiPackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.mojang.serialization.MapCodec;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class BlockMaidBeacon
extends BaseEntityBlock {
    public static final EnumProperty<Position> POSITION = EnumProperty.create((String)"position", Position.class);
    private static final VoxelShape UP_AABB = Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape DOWN_AABB = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)26.0, (double)9.5);

    public BlockMaidBeacon() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.0f, 2.0f).noOcclusion().lightLevel(s -> s.getValue(POSITION) == Position.DOWN ? 0 : 15));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(POSITION, (Comparable)((Object)Position.DOWN)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return BlockMaidBeacon.simpleCodec(properties -> new BlockMaidBeacon());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue(POSITION) != Position.DOWN) {
            return new TileEntityMaidBeacon(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : BlockMaidBeacon.createTickerHelper(type, TileEntityMaidBeacon.TYPE, TileEntityMaidBeacon::serverTick);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.getBlockEntity(pos) instanceof TileEntityMaidBeacon) {
            if (!worldIn.isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenBeaconGuiPackage(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return super.useItemOn(itemStack, state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Position position = (Position)((Object)state.getValue(POSITION));
        return position == Position.DOWN ? DOWN_AABB : UP_AABB;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.getAxis() == Direction.Axis.Y) {
            Position position = (Position)((Object)stateIn.getValue(POSITION));
            if (!(position != Position.DOWN || facing != Direction.UP || facingState.is((Block)this) && facingState.getValue(POSITION) != Position.DOWN)) {
                return Blocks.AIR.defaultBlockState();
            }
            if (!(position == Position.DOWN || facing != Direction.DOWN || facingState.is((Block)this) && facingState.getValue(POSITION) != Position.UP_W_E && facingState.getValue(POSITION) != Position.UP_N_S)) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos belowPos;
        BlockState belowState;
        Position position;
        if (!worldIn.isClientSide && player.isCreative() && (position = (Position)((Object)state.getValue(POSITION))) != Position.DOWN && (belowState = worldIn.getBlockState(belowPos = pos.below())).is((Block)this) && belowState.getValue(POSITION) == Position.DOWN) {
            worldIn.setBlock(belowPos, Blocks.AIR.defaultBlockState(), 35);
            worldIn.levelEvent(player, 2001, belowPos, Block.getId((BlockState)belowState));
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof TileEntityMaidBeacon) {
            BlockMaidBeacon.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)ItemMaidBeacon.tileEntityToItemStack((HolderLookup.Provider)worldIn.registryAccess(), (TileEntityMaidBeacon)te));
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return new ItemStack((ItemLike)InitItems.MAID_BEACON.get());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level world = context.getLevel();
        int maxHeight = world.getMaxBuildHeight() - 1;
        if (blockpos.getY() < maxHeight && world.getBlockState(blockpos.above()).canBeReplaced(context)) {
            return super.getStateForPlacement(context);
        }
        return null;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = this.getHorizontalDirection(placer);
        BlockState stateUp = facing == Direction.SOUTH || facing == Direction.NORTH ? (BlockState)this.defaultBlockState().setValue(POSITION, (Comparable)((Object)Position.UP_N_S)) : (BlockState)this.defaultBlockState().setValue(POSITION, (Comparable)((Object)Position.UP_W_E));
        worldIn.setBlock(pos.above(), stateUp, 3);
        BlockEntity te = worldIn.getBlockEntity(pos.above());
        if (te instanceof TileEntityMaidBeacon) {
            TileEntityMaidBeacon tileEntityMaidBeacon = (TileEntityMaidBeacon)te;
            ItemMaidBeacon.itemStackToTileEntity(stack, tileEntityMaidBeacon);
            tileEntityMaidBeacon.refresh();
        }
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        switch (direction) {
            default: {
                return state;
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: 
        }
        if (state.getValue(POSITION) == Position.UP_N_S) {
            return (BlockState)state.setValue(POSITION, (Comparable)((Object)Position.UP_W_E));
        }
        if (state.getValue(POSITION) == Position.UP_W_E) {
            return (BlockState)state.setValue(POSITION, (Comparable)((Object)Position.UP_N_S));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POSITION});
    }

    private Direction getHorizontalDirection(@Nullable LivingEntity placer) {
        return placer == null ? Direction.NORTH : placer.getDirection();
    }

    public static enum Position implements StringRepresentable
    {
        UP_N_S,
        UP_W_E,
        DOWN;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.US);
        }

        public String toString() {
            return this.getSerializedName();
        }
    }
}

