/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.download;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.config.ServerConfig;
import com.github.tartaricacid.touhoulittlemaid.util.HttpUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ZipFileCheck;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

@OnlyIn(value=Dist.CLIENT)
public class ClientPackDownloadManager {
    private static int CACHE_CONFIG_HASH = 0;

    public static void downloadClientPack() {
        List downloadList = (List)ServerConfig.CLIENT_PACK_DOWNLOAD_URLS.get();
        int hashCurrent = ClientPackDownloadManager.hashDownloadList(downloadList);
        if (CACHE_CONFIG_HASH != hashCurrent) {
            CustomPackLoader.reloadPacks();
            ClientPackDownloadManager.downloadAllPack(downloadList);
            CACHE_CONFIG_HASH = hashCurrent;
        }
    }

    private static void downloadAllPack(List<String> downloadList) {
        downloadList.forEach(urlText -> {
            if (StringUtils.isBlank((CharSequence)urlText)) {
                return;
            }
            ClientPackDownloadManager.download(urlText);
        });
    }

    private static void download(String urlText) {
        Proxy proxy = Minecraft.getInstance().getProxy();
        try {
            URL url = URI.create(urlText).toURL();
            String fileName = FilenameUtils.getName((String)url.getPath());
            File packFile = InfoGetManager.getPackFolder().resolve(fileName).toFile();
            ClientPackDownloadManager.downloadPack(url, packFile, proxy);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private static void downloadPack(URL url, File packFile, Proxy proxy) {
        String fileName = packFile.getName();
        InfoGetManager.sendDownloadMessage(Component.translatable((String)"gui.touhou_little_maid.resources_download.state.downloading", (Object[])new Object[]{fileName}));
        StopWatch stopWatch = StopWatch.createStarted();
        CompletableFuture<?> downloader = HttpUtil.downloadTo(packFile, url, InfoGetManager.getDownloadHeaders(), InfoGetManager.getPackMaxFileSize(), null, proxy);
        ((CompletableFuture)downloader.thenRun(() -> {
            stopWatch.stop();
            InfoGetManager.sendDownloadMessage(Component.translatable((String)"gui.touhou_little_maid.resources_download.state.downloaded", (Object[])new Object[]{fileName, (double)stopWatch.getTime(TimeUnit.MILLISECONDS) / 1000.0}));
            try {
                ClientPackDownloadManager.reloadPack(packFile);
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        })).exceptionally(error -> {
            stopWatch.stop();
            TouhouLittleMaid.LOGGER.warn("Failed to download pack file, possibly due to network issues");
            return null;
        });
    }

    private static void reloadPack(File packFile) throws IOException {
        String fileName = packFile.getName();
        if (ZipFileCheck.isZipFile(packFile)) {
            CustomPackLoader.readModelFromZipFile(packFile);
        } else {
            TouhouLittleMaid.LOGGER.error("{} file is corrupt and cannot be loaded.", (Object)fileName);
        }
    }

    private static int hashDownloadList(List<String> downloadList) {
        int[] hash = new int[]{0};
        downloadList.stream().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).forEach(entry -> {
            hash[0] = hash[0] + entry.hashCode();
        });
        return hash[0];
    }
}

