/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.ChairModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.AbstractModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.network.message.ChairModelPackage;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ChairModelGui
extends AbstractModelGui<EntityChair, ChairModelInfo> {
    private static int PAGE_INDEX = 0;
    private static int PACK_INDEX = 0;
    private static int ROW_INDEX = 0;

    public ChairModelGui(EntityChair entity) {
        super(entity, CustomPackLoader.CHAIR_MODELS.getPackList());
    }

    @Override
    protected void drawLeftEntity(GuiGraphics graphics, int middleX, int middleY, float mouseX, float mouseY) {
        float renderItemScale = CustomPackLoader.CHAIR_MODELS.getModelRenderItemScale(((EntityChair)this.entity).getModelId());
        int centerX = (middleX - 128) / 2;
        int centerY = middleY + 80;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(centerX - 68), (int)(centerY - 100), (int)(centerX + 68), (int)(centerY + 80), (int)((int)(45.0f * renderItemScale)), (float)0.0f, (float)(centerX + 25), (float)(centerY + 5), (LivingEntity)this.entity);
    }

    @Override
    protected void drawRightEntity(GuiGraphics graphics, int posX, int posY, ChairModelInfo modelItem) {
        ResourceLocation cacheIconId = modelItem.getCacheIconId();
        Map allTextures = Minecraft.getInstance().getTextureManager().byPath;
        if (((Boolean)MiscConfig.MODEL_ICON_CACHE.get()).booleanValue() && allTextures.containsKey(cacheIconId)) {
            int textureSize = 24;
            graphics.blit(cacheIconId, posX - textureSize / 2, posY - textureSize, textureSize, textureSize, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
        } else {
            this.drawEntity(graphics, posX, posY, modelItem);
        }
    }

    @Override
    protected void openDetailsGui(EntityChair entity, ChairModelInfo modelInfo) {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new ChairModelDetailsGui(entity, modelInfo));
        }
    }

    @Override
    protected void notifyModelChange(EntityChair entity, ChairModelInfo modelInfo) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ChairModelPackage(entity.getId(), modelInfo.getModelId(), modelInfo.getMountedYOffset(), modelInfo.isTameableCanRide(), modelInfo.isNoGravity()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void addModelCustomTips(ChairModelInfo modelItem, List<Component> tooltips) {
    }

    @Override
    protected int getPageIndex() {
        return PAGE_INDEX;
    }

    @Override
    protected void setPageIndex(int pageIndex) {
        PAGE_INDEX = pageIndex;
    }

    @Override
    protected int getPackIndex() {
        return PACK_INDEX;
    }

    @Override
    protected void setPackIndex(int packIndex) {
        PACK_INDEX = packIndex;
    }

    @Override
    protected int getRowIndex() {
        return ROW_INDEX;
    }

    @Override
    protected void setRowIndex(int rowIndex) {
        ROW_INDEX = rowIndex;
    }

    private void drawEntity(GuiGraphics graphics, int posX, int posY, ChairModelInfo modelItem) {
        EntityChair chair;
        ClientLevel world = this.getMinecraft().level;
        if (world == null) {
            return;
        }
        try {
            chair = (EntityChair)((Object)EntityCacheUtil.ENTITY_CACHE.get(EntityChair.TYPE, () -> ChairModelGui.lambda$drawEntity$0((Level)world)));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        chair.setModelId(modelItem.getModelId().toString());
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(posX - 18), (int)(posY - 30), (int)(posX + 18), (int)(posY + 18), (int)((int)(12.0f * modelItem.getRenderItemScale())), (float)0.0f, (float)(posX + 25), (float)(posY + 5), (LivingEntity)chair);
    }

    private static /* synthetic */ Entity lambda$drawEntity$0(Level world) throws Exception {
        Entity e = EntityChair.TYPE.create(world);
        if (e == null) {
            return new EntityChair(world);
        }
        return e;
    }
}

