/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.util.GuiTools;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class HistoryChatWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_history_chat.png");
    private static final long TICKS_PER_DAY = 24000L;
    private static final long TICKS_PER_HOUR = 1000L;
    private final boolean isLeft;
    private final ResourceLocation playerSkin;
    private final Component time;

    public HistoryChatWidget(int pX, int pY, int width, int height, Component message, ResourceLocation playerSkin, long gameTime, boolean isLeft) {
        super(pX, pY, width, height, message);
        this.isLeft = isLeft;
        this.playerSkin = playerSkin;
        this.time = this.convertGameTime(gameTime);
    }

    private Component convertGameTime(long inputGameTime) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return Component.empty();
        }
        long currentGameTime = level.getGameTime();
        long diff = currentGameTime - inputGameTime;
        if (diff < 0L) {
            return Component.empty();
        }
        long days = diff / 24000L;
        long hours = (diff %= 24000L) / 1000L;
        if (days > 0L) {
            return Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.days", (Object[])new Object[]{days});
        }
        if (hours > 0L) {
            return Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.hours", (Object[])new Object[]{hours});
        }
        return Component.translatable((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.just_now");
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        this.drawBackground(graphics);
        this.drawAvatar(graphics);
        this.renderString(graphics, Minecraft.getInstance().font);
    }

    private void drawAvatar(GuiGraphics graphics) {
        int xOffset;
        int size = 16;
        int offset = 6;
        int n = xOffset = this.isLeft ? -size - offset : this.getWidth() + offset;
        if (this.isLeft) {
            graphics.blit(TEXTURE, this.getX() + xOffset, this.getHeightMiddle(size), 0, 32, size, size);
        } else {
            PlayerFaceRenderer.draw((GuiGraphics)graphics, (ResourceLocation)this.playerSkin, (int)(this.getX() + xOffset), (int)this.getHeightMiddle(size), (int)size);
        }
    }

    private void drawBackground(GuiGraphics graphics) {
        int heightMiddle = this.getHeightMiddle(14);
        GuiTools.blitNineSliced(graphics, TEXTURE, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 8, 4, 100, 16, 0, this.getTextureY());
        if (this.isLeft) {
            graphics.blit(TEXTURE, this.getX() - 4, heightMiddle, 100, 16, 6, 14);
        } else {
            graphics.blit(TEXTURE, this.getX() + this.getWidth() - 2, heightMiddle, 100, 0, 6, 14);
        }
    }

    public void renderString(GuiGraphics graphics, Font font) {
        Component message = this.getMessage();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.isLeft) {
            graphics.drawWordWrap(font, (FormattedText)message, this.getX() + 5, this.getY() + 5, this.getWidth() - 10, 0x555555);
        } else {
            graphics.drawWordWrap(font, (FormattedText)message, this.getX() + 5, this.getY() + 5, this.getWidth() - 10, 0xFFFFFF);
        }
        float scale = 0.5f;
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 0.0f);
        if (this.isLeft) {
            graphics.drawString(font, this.time.getVisualOrderText(), (float)(this.getX() + 2) / scale, (float)(this.getY() - 5) / scale, 0x999999, false);
        } else {
            float width = (float)font.width((FormattedText)this.time) * scale;
            graphics.drawString(font, this.time.getVisualOrderText(), ((float)(this.getX() + this.getWidth()) - width - 2.0f) / scale, (float)(this.getY() - 5) / scale, 0x999999, false);
        }
        graphics.pose().popPose();
    }

    private int getTextureY() {
        return this.isLeft ? 16 : 0;
    }

    private int getHeightMiddle(int height) {
        return this.getY() + (this.getHeight() - height) / 2;
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }
}

