/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MaidAIChatConfigButton
extends Button {
    private static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_ai_chat_config.png");
    private final OnPress leftPress;
    private final OnPress rightPress;
    private boolean leftClicked = false;
    private Component value;

    public MaidAIChatConfigButton(int x, int y, Component title, Component value, OnPress onLeftPressIn, OnPress onRightPressIn) {
        super(Button.builder((Component)title, b -> {}).pos(x, y).size(164, 13));
        this.leftPress = onLeftPressIn;
        this.rightPress = onRightPressIn;
        this.value = value;
    }

    public MaidAIChatConfigButton(int x, int y, Component title, Component value, OnPress onPress) {
        this(x, y, title, value, onPress, onPress);
    }

    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.enableDepthTest();
        if (this.isHovered) {
            graphics.blit(ICON, this.getX(), this.getY(), 6.0f, 150.0f, this.width, this.height, 256, 256);
        } else {
            graphics.blit(ICON, this.getX(), this.getY(), 6.0f, 137.0f, this.width, this.height, 256, 256);
        }
        this.drawButtonText(graphics, mc.font);
    }

    public void setValue(Component value) {
        this.value = value;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        boolean clickY;
        if (!this.active || !this.visible) {
            return false;
        }
        boolean leftClickX = (double)(this.getX() + 62) <= mouseX && mouseX <= (double)(this.getX() + 72);
        boolean rightClickX = (double)(this.getX() + 154) <= mouseX && mouseX <= (double)(this.getX() + 164);
        boolean bl = clickY = (double)this.getY() <= mouseY && mouseY <= (double)(this.getY() + this.getHeight());
        if (leftClickX && clickY) {
            this.leftClicked = true;
            return true;
        }
        if (rightClickX && clickY) {
            this.leftClicked = false;
            return true;
        }
        return false;
    }

    public void onPress() {
        if (this.leftClicked) {
            this.leftPress.onPress(this);
        } else {
            this.rightPress.onPress(this);
        }
    }

    public void drawButtonText(GuiGraphics graphics, Font font) {
        float scale = 0.75f;
        FormattedCharSequence leftText = this.getMessage().getVisualOrderText();
        FormattedCharSequence rightText = this.value.getVisualOrderText();
        float leftTextX = (float)(this.getX() + 5) / scale;
        float leftTextY = (float)(this.getY() + 4) / scale;
        float rightTextX = ((float)(this.getX() + 113) - (float)font.width(rightText) * scale / 2.0f) / scale;
        float rightTextY = (float)(this.getY() + 4) / scale;
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 1.0f);
        graphics.drawString(font, leftText, leftTextX, leftTextY, 0x444444, false);
        graphics.drawString(font, rightText, rightTextX, rightTextY, 0x55FF55, false);
        graphics.pose().popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(MaidAIChatConfigButton var1);
    }
}

