/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.ClientHooks;

public class ChatBubbleRenderer {
    private final EntityMaidRenderer renderer;

    public ChatBubbleRenderer(EntityMaidRenderer renderer) {
        this.renderer = renderer;
    }

    public void render(EntityGraphics graphics) {
        double distance;
        EntityMaid maid = graphics.getMaid();
        if (!ClientHooks.isNameplateInRenderDistance((Entity)maid, (double)(distance = this.renderer.getDispatcher().distanceToSqr((Entity)maid)))) {
            return;
        }
        ChatBubbleDataCollection chatBubble = maid.getChatBubbleManager().getChatBubbleDataCollection();
        if (chatBubble == null || chatBubble.isEmpty()) {
            return;
        }
        int size = chatBubble.size();
        boolean isOdd = this.isOdd(size);
        int sideNum = isOdd ? size - 1 : size;
        int marginY = 16;
        int leftY = 0;
        int rightY = 0;
        ObjectIterator<IChatBubbleData> iterator = chatBubble.iterator();
        for (int i = 0; i < sideNum && iterator.hasNext(); ++i) {
            IChatBubbleRenderer bubble;
            if (this.isOdd(i)) {
                bubble = ((IChatBubbleData)iterator.next()).getRenderer(IChatBubbleRenderer.Position.LEFT);
                this.renderChatBubble(graphics, bubble, IChatBubbleRenderer.Position.LEFT, leftY);
                leftY += bubble.getHeight() + marginY;
                continue;
            }
            bubble = ((IChatBubbleData)iterator.next()).getRenderer(IChatBubbleRenderer.Position.RIGHT);
            this.renderChatBubble(graphics, bubble, IChatBubbleRenderer.Position.RIGHT, rightY);
            rightY += bubble.getHeight() + marginY;
        }
        if (isOdd) {
            int middleY = Math.max(leftY, rightY);
            IChatBubbleData last = chatBubble.getLast();
            IChatBubbleRenderer bubble = last.getRenderer(IChatBubbleRenderer.Position.CENTER);
            this.renderChatBubble(graphics, bubble, IChatBubbleRenderer.Position.CENTER, middleY);
        }
    }

    private void renderChatBubble(EntityGraphics graphics, IChatBubbleRenderer chatBubble, IChatBubbleRenderer.Position position, int y) {
        int offset = 5;
        int marginX = 1;
        int width = chatBubble.getWidth();
        int height = chatBubble.getHeight();
        ResourceLocation texture = chatBubble.getBackgroundTexture();
        int bgWidth = width + 2 * offset;
        int bgHeight = height + 2 * offset;
        graphics.getPoseStack().pushPose();
        graphics.getPoseStack().translate(0.0f, (float)(-y), 0.0f);
        RenderSystem.enableDepthTest();
        if (position == IChatBubbleRenderer.Position.LEFT) {
            graphics.blitNineSliced(texture, -marginX - bgWidth, -bgHeight, bgWidth, bgHeight, 8, 8, 48, 24, 0, 0);
            graphics.getPoseStack().translate(0.0, 0.0, -0.01);
            graphics.blit(texture, -marginX - 8, -8, 32, 24, 16, 16);
            graphics.getPoseStack().translate((double)(-marginX - bgWidth + offset), (double)(-bgHeight + offset), -0.01);
            chatBubble.render(this.renderer, graphics);
        } else if (position == IChatBubbleRenderer.Position.RIGHT) {
            graphics.blitNineSliced(texture, marginX, -bgHeight, bgWidth, bgHeight, 8, 8, 48, 24, 0, 0);
            graphics.getPoseStack().translate(0.0, 0.0, -0.01);
            graphics.blit(texture, marginX - 8, -8, 0, 24, 16, 16);
            graphics.getPoseStack().translate((double)(offset + marginX), (double)(-bgHeight + offset), -0.01);
            chatBubble.render(this.renderer, graphics);
        } else if (position == IChatBubbleRenderer.Position.CENTER) {
            graphics.blitNineSliced(texture, -bgWidth / 2, -bgHeight, bgWidth, bgHeight, 8, 8, 48, 24, 0, 0);
            graphics.getPoseStack().translate(0.0, 0.0, -0.01);
            graphics.blit(texture, -8, -8, 16, 24, 16, 16);
            graphics.getPoseStack().translate((double)(-bgWidth) / 2.0 + (double)offset, (double)(-bgHeight + offset), -0.01);
            chatBubble.render(this.renderer, graphics);
        }
        graphics.getPoseStack().popPose();
    }

    private boolean isOdd(int number) {
        return number % 2 != 0;
    }
}

