/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.client.decoder.GifDecoder;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class GifTexture
extends SizeTexture
implements Tickable {
    private final ResourceLocation texturePath;
    private NativeImage[] frames;
    private int[] frameDelays;
    private int currentFrame = 0;
    private int currentFrameDelay = 0;
    private int width = 16;
    private int height = 16;

    public GifTexture(ResourceLocation texturePath) {
        this.texturePath = texturePath;
    }

    public void load(ResourceManager manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.doLoad(manager));
        } else {
            this.doLoad(manager);
        }
    }

    private void doLoad(ResourceManager manager) {
        try (InputStream stream = manager.open(this.texturePath);){
            GifDecoder decoder = new GifDecoder();
            decoder.read(stream);
            int totalFrames = decoder.getFrameCount();
            Dimension frameSize = decoder.getFrameSize();
            this.frames = new NativeImage[totalFrames];
            this.frameDelays = new int[totalFrames];
            this.width = frameSize.width;
            this.height = frameSize.height;
            for (int i = 0; i < totalFrames; ++i) {
                NativeImage nativeImage = new NativeImage(this.width, this.height, true);
                BufferedImage image = decoder.getFrame(i);
                for (int y = 0; y < image.getHeight(); ++y) {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        int argb = image.getRGB(x, y);
                        int a = argb >> 24 & 0xFF;
                        int r = argb >> 16 & 0xFF;
                        int g = argb >> 8 & 0xFF;
                        int b = argb & 0xFF;
                        nativeImage.setPixelRGBA(x, y, a << 24 | b << 16 | g << 8 | r);
                    }
                }
                this.frames[i] = nativeImage;
                this.frameDelays[i] = Math.max(decoder.getDelay(i) / 50, 1);
            }
            TextureUtil.prepareImage((int)this.getId(), (int)0, (int)this.width, (int)this.height);
            this.frames[0].upload(0, 0, 0, 0, 0, this.width, this.height, false, false, false, false);
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to load gif texture: {}", (Object)this.texturePath, (Object)e);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isExist() {
        return true;
    }

    public void tick() {
        if (this.frames == null || this.frames.length == 0) {
            return;
        }
        ++this.currentFrameDelay;
        if (this.currentFrameDelay >= this.frameDelays[this.currentFrame]) {
            this.currentFrameDelay = 0;
            this.currentFrame = (this.currentFrame + 1) % this.frames.length;
            TextureUtil.prepareImage((int)this.getId(), (int)0, (int)this.width, (int)this.height);
            this.frames[this.currentFrame].upload(0, 0, 0, 0, 0, this.width, this.height, false, false);
        }
    }
}

