/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.pojo;

import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.Md5Utils;
import com.google.common.collect.Lists;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class CustomModelPack<T extends IModelInfo> {
    @Expose(serialize=false, deserialize=false)
    private String id = "";
    @SerializedName(value="date")
    private String date;
    @SerializedName(value="model_list")
    private List<T> modelList;
    @SerializedName(value="pack_name")
    private String packName;
    @SerializedName(value="author")
    private List<String> author;
    @SerializedName(value="description")
    private List<String> description;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="icon")
    private ResourceLocation icon;
    @SerializedName(value="icon_delay")
    private int iconDelay = 2;
    @Expose(deserialize=false)
    private AnimationState iconAnimation = AnimationState.UNCHECK;
    @Expose(deserialize=false)
    private int iconAspectRatio = 1;

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDate() {
        return this.date;
    }

    public List<T> getModelList() {
        return this.modelList;
    }

    public String getPackName() {
        return this.packName;
    }

    public List<String> getAuthor() {
        return this.author;
    }

    public List<String> getDescription() {
        return this.description;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public ResourceLocation getIcon() {
        return this.icon;
    }

    public AnimationState getIconAnimation() {
        return this.iconAnimation;
    }

    public void setIconAnimation(AnimationState iconAnimation) {
        this.iconAnimation = iconAnimation;
    }

    public int getIconAspectRatio() {
        return this.iconAspectRatio;
    }

    public void setIconAspectRatio(int iconAspectRatio) {
        this.iconAspectRatio = iconAspectRatio;
    }

    public int getIconDelay() {
        return this.iconDelay;
    }

    public CustomModelPack<T> decorate(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new RuntimeException("pack id must not be empty");
        }
        this.id = id;
        if (this.packName == null) {
            throw new JsonSyntaxException("Expected \"pack_name\" in pack");
        }
        if (this.modelList == null || this.modelList.isEmpty()) {
            throw new JsonSyntaxException("Expected \"model_list\" in pack");
        }
        if (this.description == null) {
            this.description = Collections.EMPTY_LIST;
        }
        if (this.author == null) {
            this.author = Collections.EMPTY_LIST;
        }
        if (this.icon == null) {
            this.icon = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/empty_model_pack_icon.png");
        }
        if (this.iconDelay <= 0) {
            this.iconDelay = 1;
        }
        this.modelList.forEach(IModelInfo::decorate);
        ArrayList newModelList = Lists.newArrayList();
        for (IModelInfo item : this.modelList) {
            ResourceLocation modelId = item.getModelId();
            newModelList.add(item.extra(modelId, item.getTexture()));
            List<ResourceLocation> extraTextures = item.getExtraTextures();
            if (extraTextures == null || extraTextures.isEmpty()) continue;
            extraTextures.forEach(r -> {
                String suffix = Md5Utils.md5Hex(r.getPath()).toLowerCase(Locale.US);
                ResourceLocation newModelId = ResourceLocation.fromNamespaceAndPath((String)modelId.getNamespace(), (String)(modelId.getPath() + "_" + suffix));
                newModelList.add(item.extra(newModelId, (ResourceLocation)r));
            });
        }
        this.modelList = newModelList;
        return this;
    }

    public static enum AnimationState {
        TRUE,
        FALSE,
        UNCHECK;

    }
}

