/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ClientMaidTooltip
implements ClientTooltipComponent {
    @Nullable
    private final MaidModelInfo info;
    private final YsmMaidInfo ysmMaidInfo;
    private final MutableComponent name;
    private final String customName;

    public ClientMaidTooltip(ItemMaidTooltip tooltip) {
        this.info = CustomPackLoader.MAID_MODELS.getInfo(tooltip.modelId()).orElse(null);
        this.ysmMaidInfo = tooltip.ysmMaidInfo();
        this.name = this.getName(this.info, this.ysmMaidInfo);
        this.customName = tooltip.customName();
    }

    public MutableComponent getName(MaidModelInfo info, YsmMaidInfo ysmMaidInfo) {
        if (YsmCompat.isInstalled() && ysmMaidInfo.isYsmModel()) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return Component.empty();
            }
            MutableComponent name = Component.Serializer.fromJson((String)ysmMaidInfo.name(), (HolderLookup.Provider)level.registryAccess());
            if (name == null || name.equals((Object)Component.empty())) {
                return Component.literal((String)ysmMaidInfo.modelId());
            }
            return name;
        }
        if (info == null) {
            return Component.empty();
        }
        return Component.translatable((String)ParseI18n.getI18nKey(info.getName()));
    }

    public int getHeight() {
        return 70;
    }

    public int getWidth(Font font) {
        return Math.max(font.width((FormattedText)this.name), 50);
    }

    public void renderImage(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        EntityMaid maid;
        if (this.info == null) {
            return;
        }
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        RegistryAccess access = Minecraft.getInstance().level.registryAccess();
        MutableComponent customNameComponent = null;
        if (StringUtils.isNotBlank((CharSequence)this.customName)) {
            customNameComponent = Component.Serializer.fromJson((String)this.customName, (HolderLookup.Provider)access);
            if (customNameComponent != null) {
                guiGraphics.drawString(font, (Component)customNameComponent.withStyle(ChatFormatting.GRAY), pX, pY + 2, 0xFFFFFF);
            }
        } else {
            guiGraphics.drawString(font, (Component)this.name.withStyle(ChatFormatting.GRAY), pX, pY + 2, 0xFFFFFF);
        }
        int width = this.getWidth(font);
        int posX = pX + width / 2;
        int posY = pY + 64;
        double rot = (double)System.currentTimeMillis() / 25.0 % 360.0;
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(rot));
        pose.mul((Quaternionfc)rotation);
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> ClientMaidTooltip.lambda$renderImage$1((Level)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (StringUtils.isNotBlank((CharSequence)this.customName)) {
            maid.setCustomName((Component)customNameComponent);
        }
        if (this.info.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(this.info.getModelId().toString());
        }
        if (YsmCompat.isInstalled() && this.ysmMaidInfo.isYsmModel()) {
            maid.setIsYsmModel(true);
            maid.setYsmModel(this.ysmMaidInfo.modelId(), this.ysmMaidInfo.textureId(), (Component)this.name);
        } else {
            maid.setIsYsmModel(false);
        }
        guiGraphics.enableScissor(pX, posY - 50, pX + width, posY);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)posX, (float)posY, (float)((int)(25.0f * this.info.getRenderItemScale())), (Vector3f)new Vector3f(), (Quaternionf)pose, null, (LivingEntity)maid);
        guiGraphics.disableScissor();
    }

    private static /* synthetic */ Entity lambda$renderImage$1(Level world) throws Exception {
        Entity e = EntityMaid.TYPE.create(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

