/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidBed;
import com.github.tartaricacid.touhoulittlemaid.block.BlockScarecrow;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.loot.RandomBoardStateFunction;
import com.github.tartaricacid.touhoulittlemaid.loot.SetTankCountFunction;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableGenerator {
    public static final ResourceKey<LootTable> GIVE_SMART_SLAB = LootTableGenerator.getLootTableKey("give_smart_slab");
    public static final ResourceKey<LootTable> ADVANCEMENT_POWER_POINT = LootTableGenerator.getLootTableKey("advancement/power_point");
    public static final ResourceKey<LootTable> CAKE = LootTableGenerator.getLootTableKey("advancement/cake");
    public static final ResourceKey<LootTable> CHEST_POWER_POINT = LootTableGenerator.getLootTableKey("chest/power_point");
    public static final ResourceKey<LootTable> FISHING_POWER_POINT = LootTableGenerator.getLootTableKey("fishing/power_point");
    public static final ResourceKey<LootTable> SHRINE_LESS = LootTableGenerator.getLootTableKey("chest/shrine_less");
    public static final ResourceKey<LootTable> SHRINE_MORE = LootTableGenerator.getLootTableKey("chest/shrine_more");
    public static final ResourceKey<LootTable> SPAWN_BONUS = LootTableGenerator.getLootTableKey("chest/spawn_bonus");
    public static final ResourceKey<LootTable> NORMAL_BACKPACK = LootTableGenerator.getLootTableKey("chest/normal_backpack");
    public static final ResourceKey<LootTable> FURNACE_OR_CRAFTING_TABLE_BACKPACK = LootTableGenerator.getLootTableKey("chest/furnace_or_crafting_table_backpack");
    public static final ResourceKey<LootTable> TANK_BACKPACK = LootTableGenerator.getLootTableKey("chest/tank_backpack");
    public static final ResourceKey<LootTable> ENDER_CHEST_BACKPACK = LootTableGenerator.getLootTableKey("chest/ender_chest_backpack");
    public static final ResourceKey<LootTable> NORMAL_BAUBLE = LootTableGenerator.getLootTableKey("chest/normal_bauble");
    public static final ResourceKey<LootTable> RARE_BAUBLE = LootTableGenerator.getLootTableKey("chest/rare_bauble");
    public static final ResourceKey<LootTable> VERY_RARE_BAUBLE = LootTableGenerator.getLootTableKey("chest/very_rare_bauble");
    public static final ResourceKey<LootTable> STRUCTURE_SPAWN_MAID_GIFT = LootTableGenerator.getLootTableKey("chest/structure_spawn_maid_gift");
    public static final ResourceKey<LootTable> MAID_BURIED_TREASURE = LootTableGenerator.getLootTableKey("chest/maid_buried_treasure");
    public static final ResourceKey<LootTable> RANDOM_BOARD_STATE = LootTableGenerator.getLootTableKey("chest/random_board_state");

    public static ResourceKey<LootTable> getLootTableKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)name));
    }

    public static class BlockLootTables
    extends BlockLootSubProvider {
        public final Set<Block> knownBlocks = new HashSet<Block>();

        public BlockLootTables(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add((Block)InitBlocks.MAID_BED.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)BlockMaidBed.PART, (Comparable)BedPart.HEAD));
            this.add((Block)InitBlocks.SCARECROW.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)BlockScarecrow.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Block)InitBlocks.MODEL_SWITCHER.get());
            this.dropSelf((Block)InitBlocks.KEYBOARD.get());
            this.dropSelf((Block)InitBlocks.BOOKSHELF.get());
            this.dropSelf((Block)InitBlocks.COMPUTER.get());
            this.dropSelf((Block)InitBlocks.SHRINE.get());
        }

        public void add(Block block, LootTable.Builder builder) {
            this.knownBlocks.add(block);
            super.add(block, builder);
        }

        public Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }
    }

    public static class EntityLootTables
    extends EntityLootSubProvider {
        public final Set<EntityType<?>> knownEntities = Sets.newHashSet();

        protected EntityLootTables(HolderLookup.Provider registries) {
            super(FeatureFlags.REGISTRY.allFlags(), registries);
        }

        public void generate() {
            this.add(InitEntities.BOX.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PAPER))));
        }

        protected boolean canHaveLootTable(EntityType<?> type) {
            return true;
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return this.knownEntities.stream();
        }

        protected void add(EntityType<?> type, LootTable.Builder builder) {
            this.add(type, (ResourceKey<LootTable>)type.getDefaultLootTable(), builder);
        }

        protected void add(EntityType<?> type, ResourceKey<LootTable> lootTable, LootTable.Builder builder) {
            super.add(type, lootTable, builder);
            this.knownEntities.add(type);
        }
    }

    public record ChestLootTables(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(CHEST_POWER_POINT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.POWER_POINT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2))));
            consumer.accept(FISHING_POWER_POINT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.POWER_POINT.get()))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(9))));
            consumer.accept(SHRINE_LESS, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.SHRINE.get()))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(9))));
            consumer.accept(SHRINE_MORE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.SHRINE.get()))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2))));
            consumer.accept(SPAWN_BONUS, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_SMALL.get())).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_MIDDLE.get())).setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_BIG.get())).setWeight(4))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.POWER_POINT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)9.0f))))));
            consumer.accept(NORMAL_BACKPACK, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_SMALL.get())).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_MIDDLE.get())).setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_BIG.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50))));
            consumer.accept(FURNACE_OR_CRAFTING_TABLE_BACKPACK, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.FURNACE_BACKPACK.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.CRAFTING_TABLE_BACKPACK.get()))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(8))));
            LootPoolSingletonContainer.Builder tank1 = LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.TANK_BACKPACK.get())).apply((LootItemFunction.Builder)new SetTankCountFunction.Builder((Fluid)Fluids.LAVA, 9));
            LootPoolSingletonContainer.Builder tank2 = LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.TANK_BACKPACK.get())).apply((LootItemFunction.Builder)new SetTankCountFunction.Builder((Fluid)Fluids.LAVA, 4));
            LootPoolSingletonContainer.Builder tank3 = LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.TANK_BACKPACK.get())).apply((LootItemFunction.Builder)new SetTankCountFunction.Builder((Fluid)Fluids.LAVA, 3));
            consumer.accept(TANK_BACKPACK, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)tank1).add((LootPoolEntryContainer.Builder)tank2).add((LootPoolEntryContainer.Builder)tank3).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(12))));
            consumer.accept(ENDER_CHEST_BACKPACK, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.ENDER_CHEST_BACKPACK.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(4))));
            consumer.accept(NORMAL_BAUBLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.EXPLOSION_PROTECT_BAUBLE.get())).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.FIRE_PROTECT_BAUBLE.get())).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.PROJECTILE_PROTECT_BAUBLE.get())).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.MAGIC_PROTECT_BAUBLE.get())).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.FALL_PROTECT_BAUBLE.get())).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.DROWN_PROTECT_BAUBLE.get())).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.EXPLOSION_PROTECT_BAUBLE.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.FIRE_PROTECT_BAUBLE.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.PROJECTILE_PROTECT_BAUBLE.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.MAGIC_PROTECT_BAUBLE.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.FALL_PROTECT_BAUBLE.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.DROWN_PROTECT_BAUBLE.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(90))));
            consumer.accept(RARE_BAUBLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.NIMBLE_FABRIC.get())).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.NIMBLE_FABRIC.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.ITEM_MAGNET_BAUBLE.get()))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(6))));
            consumer.accept(VERY_RARE_BAUBLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.ULTRAMARINE_ORB_ELIXIR.get())).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.ULTRAMARINE_ORB_ELIXIR.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(4))));
            LootItemConditionalFunction.Builder setDamage = SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.06f, (float)0.1f));
            consumer.accept(STRUCTURE_SPAWN_MAID_GIFT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CAKE))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.CAMERA.get())).apply((LootItemFunction.Builder)setDamage))));
            consumer.accept(MAID_BURIED_TREASURE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.SMART_SLAB_EMPTY.get()))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(4))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.SHRINE.get()))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem())));
            RandomBoardStateFunction.Builder library = RandomBoardStateFunction.create().addTag("library");
            consumer.accept(RANDOM_BOARD_STATE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.GOMOKU_BOARD_STATE.get())).apply((LootItemFunction.Builder)library)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.CCHESS_BOARD_STATE.get())).apply((LootItemFunction.Builder)library)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.WCHESS_BOARD_STATE.get())).apply((LootItemFunction.Builder)library))));
        }
    }

    public record AdvancementLootTables(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(GIVE_SMART_SLAB, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(InitItems.SMART_SLAB_INIT))));
            consumer.accept(ADVANCEMENT_POWER_POINT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)InitItems.POWER_POINT.get())))));
            consumer.accept(CAKE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CAKE))));
        }
    }
}

