/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ride;

import com.github.tartaricacid.touhoulittlemaid.api.entity.fishing.IFishingType;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.fishing.FishingTypeManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MaidRideFindWaterTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 100;
    private final int verticalSearchRange;
    private final int searchRange;
    protected int verticalSearchStart;
    private IFishingType fishingType = null;
    private BlockPos waterPos = null;

    public MaidRideFindWaterTask(int searchRange, int verticalSearchRange) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.searchRange = searchRange;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(100);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return super.checkExtraStartConditions(worldIn, owner) && owner.fishing == null;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        ItemStack mainHandItem = maid.getMainHandItem();
        this.fishingType = FishingTypeManager.getFishingType(mainHandItem);
        if (this.fishingType.isFishingRod(mainHandItem)) {
            if (this.waterPos == null) {
                this.searchForDestination(worldIn, maid, mainHandItem);
                return;
            }
            if (!this.posCheck(maid)) {
                this.waterPos = null;
                return;
            }
            if (this.fishingType.suitableFishingHook(maid, (Level)worldIn, mainHandItem, this.waterPos)) {
                Vec3 centerPos = Vec3.atCenterOf((Vec3i)this.waterPos);
                MaidFishingHook fishingHook = this.fishingType.getFishingHook(maid, (Level)worldIn, mainHandItem, centerPos);
                worldIn.addFreshEntity((Entity)fishingHook);
                worldIn.playSound(null, maid.getX(), maid.getY(), maid.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.getRandom().nextFloat() * 0.4f + 0.8f));
                maid.swing(InteractionHand.MAIN_HAND);
                maid.getLookControl().setLookAt(centerPos);
            } else {
                this.waterPos = null;
            }
        }
    }

    protected final void searchForDestination(ServerLevel worldIn, EntityMaid maid, ItemStack rod) {
        BlockPos centrePos = maid.getBrainSearchPos();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int y = this.verticalSearchStart;
        while (y <= this.verticalSearchRange) {
            for (int i = 0; i < this.searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.setWithOffset((Vec3i)centrePos, x, y - 1, z);
                        if (maid.isWithinRestriction((BlockPos)mutableBlockPos) && this.fishingType.suitableFishingHook(maid, (Level)worldIn, rod, (BlockPos)mutableBlockPos)) {
                            maid.getLookControl().setLookAt((double)mutableBlockPos.getX(), (double)mutableBlockPos.getY(), (double)mutableBlockPos.getZ());
                            this.waterPos = mutableBlockPos;
                            this.setNextCheckTickCount(5);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
    }

    private boolean posCheck(EntityMaid maid) {
        int distanceSqr = this.searchRange * this.searchRange;
        Vec3 waterVec = new Vec3((double)this.waterPos.getX(), (double)this.waterPos.getY(), (double)this.waterPos.getZ());
        return maid.distanceToSqr(waterVec) < (double)distanceSqr && maid.isWithinRestriction(this.waterPos);
    }
}

