/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class MaidPanicTask
extends Behavior<EntityMaid> {
    public MaidPanicTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_HOSTILE, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.HURT_BY, (Object)MemoryStatus.REGISTERED));
    }

    public static boolean hasHostile(EntityMaid maid) {
        return maid.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_HOSTILE);
    }

    public static boolean isHurt(EntityMaid maid) {
        return maid.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }

    public static boolean canPanic(EntityMaid maid) {
        return maid.getTask().enablePanic(maid);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        boolean hurtOrHostile;
        boolean bl = hurtOrHostile = MaidPanicTask.isHurt(maid) || MaidPanicTask.hasHostile(maid);
        if (MaidPanicTask.canPanic(maid) && hurtOrHostile) {
            Brain<EntityMaid> brain = maid.getBrain();
            if (!brain.isActive(Activity.PANIC)) {
                brain.eraseMemory(MemoryModuleType.PATH);
                brain.eraseMemory(MemoryModuleType.WALK_TARGET);
                brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
            }
            brain.setActiveActivityIfPossible(Activity.PANIC);
        }
    }
}

