/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.goal;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;

public class MaidTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
    protected final PathfinderMob mob;
    private final TargetingConditions targetingConditions;
    private final double speedModifier;
    private final Predicate<ItemStack> items;
    private final boolean canScare;
    @Nullable
    protected EntityMaid maid;
    private double px;
    private double py;
    private double pz;
    private int calmDown;
    private boolean isRunning;

    public MaidTemptGoal(PathfinderMob mob, double speedModifier, Predicate<ItemStack> items, boolean canScare) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.items = items;
        this.canScare = canScare;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.copy().selector(this::shouldFollow);
    }

    public boolean canUse() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.maid = (EntityMaid)this.mob.level().getNearestEntity(EntityMaid.class, this.targetingConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ(), this.mob.getBoundingBox().inflate(10.0));
        return this.maid != null;
    }

    private boolean shouldFollow(LivingEntity livingEntity) {
        return this.items.test(livingEntity.getMainHandItem()) || this.items.test(livingEntity.getOffhandItem());
    }

    public boolean canContinueToUse() {
        if (this.canScare()) {
            if (this.mob.distanceToSqr((Entity)this.maid) < 36.0) {
                if (this.maid.distanceToSqr(this.px, this.py, this.pz) > 0.01) {
                    return false;
                }
            } else {
                this.px = this.maid.getX();
                this.py = this.maid.getY();
                this.pz = this.maid.getZ();
            }
        }
        return this.canUse();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void start() {
        this.px = this.maid.getX();
        this.py = this.maid.getY();
        this.pz = this.maid.getZ();
        this.isRunning = true;
    }

    public void stop() {
        this.maid = null;
        this.mob.getNavigation().stop();
        this.calmDown = MaidTemptGoal.reducedTickDelay((int)100);
        this.isRunning = false;
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.maid, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr((Entity)this.maid) < 6.25) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.maid, this.speedModifier);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

