/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item.control;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IBroomControl;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlayerBroomControl
implements IBroomControl {
    private final EntityBroom broom;

    public PlayerBroomControl(EntityBroom broom) {
        this.broom = broom;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean inControl(Player player, @Nullable EntityMaid maid) {
        return true;
    }

    @Override
    public void travel(Player player, EntityMaid maid) {
        boolean hasInput;
        boolean keyForward = player.zza > 0.0f;
        boolean keyBack = player.zza < 0.0f;
        boolean keyLeft = player.xxa > 0.0f;
        boolean keyRight = player.xxa < 0.0f;
        boolean keySneak = player.isShiftKeyDown();
        boolean keyJump = IBroomControl.keyJump(player);
        Vec3 currentMotion = this.broom.getDeltaMovement();
        boolean bl = hasInput = keyForward || keyBack || keyLeft || keyRight || keyJump || keySneak;
        if (hasInput) {
            float strafe = keyLeft ? 0.2f : (keyRight ? -0.2f : 0.0f);
            float vertical = 0.0f;
            if (keyJump) {
                vertical = 0.25f;
            } else if (keySneak) {
                vertical = -0.2f;
            } else if (keyForward) {
                vertical = -(player.getXRot() - 10.0f) / 360.0f;
            }
            float forward = keyForward ? 0.375f : (keyBack ? -0.2f : 0.0f);
            double playerSpeed = player.getAttributeValue(Attributes.MOVEMENT_SPEED);
            double speed = Math.max(playerSpeed - 0.1, 0.0) * 2.5 + 0.1;
            Vec3 targetMotion = new Vec3((double)strafe, (double)vertical, (double)forward).scale(speed * 20.0);
            targetMotion = targetMotion.yRot((float)((double)(-this.broom.getYRot()) * Math.PI / 180.0));
            Vec3 newMotion = currentMotion.lerp(targetMotion, 0.25);
            this.broom.setDeltaMovement(newMotion);
        } else {
            this.broom.setDeltaMovement(currentMotion.scale(0.75));
        }
    }

    @Override
    public void tickRot(Player player, EntityMaid maid) {
        this.broom.yBodyRot = this.broom.yHeadRot = this.broom.getYRot();
        this.broom.yRotO = this.broom.yHeadRot;
        this.broom.setRot(player.getYRot(), player.getXRot());
    }
}

