/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class EntityThrowPowerPoint
extends ThrowableItemProjectile {
    public static final EntityType<EntityThrowPowerPoint> TYPE = EntityType.Builder.of(EntityThrowPowerPoint::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build("throw_power_point");

    public EntityThrowPowerPoint(EntityType<EntityThrowPowerPoint> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityThrowPowerPoint(Level world, LivingEntity thrower) {
        super(TYPE, thrower, world);
    }

    public EntityThrowPowerPoint(Level world, double x, double y, double z) {
        super(TYPE, x, y, z, world);
    }

    protected Item getDefaultItem() {
        return (Item)InitItems.POWER_POINT.get();
    }

    public double getGravity() {
        return 0.07f;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level.isClientSide) {
            int value;
            this.level.levelEvent(2002, this.blockPosition(), PotionContents.getColor((Holder)Potions.HEALING));
            for (int count = 30 + this.level.random.nextInt(30) + this.level.random.nextInt(30); count > 0; count -= value) {
                value = EntityPowerPoint.getPowerValue(count);
                this.level.addFreshEntity((Entity)new EntityPowerPoint(this.level, this.getX(), this.getY(), this.getZ(), value));
            }
            this.discard();
        }
    }
}

