/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task.meal;

import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.event.MaidMealRegConfigEvent;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public class DefaultMaidHealSelfMeal
implements IMaidMeal {
    private static final int MAX_PROBABILITY = 5;

    @Override
    public boolean canMaidEat(EntityMaid maid, ItemStack stack, InteractionHand hand) {
        return stack.getFoodProperties(null) != null && !IMaidMeal.isBlockList(stack, (List)MaidConfig.MAID_HEAL_MEALS_BLOCK_LIST.get()) && !IMaidMeal.isBlockList(stack, MaidMealRegConfigEvent.HEAL_MEAL_REGEX);
    }

    @Override
    public void onMaidEat(EntityMaid maid, ItemStack stack, InteractionHand hand) {
        FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)maid);
        if (foodProperties != null) {
            maid.getMaidBauble().fireEvent((b, s) -> {
                b.onMaidEat(maid, (ItemStack)s, stack, MaidMealType.HEAL_MEAL);
                return false;
            });
            maid.startUsingItem(hand);
            int nutrition = foodProperties.nutrition();
            float saturation = foodProperties.saturation();
            float total = (float)nutrition + saturation;
            if ((float)maid.getRandom().nextInt(5) < total) {
                float healCount = Math.max(total / 5.0f, 1.0f);
                maid.heal(healCount);
                NetworkHandler.sendToNearby((Entity)maid, new SpawnParticlePackage(maid.getId(), SpawnParticlePackage.Type.HEAL, stack.getUseDuration((LivingEntity)maid)));
            }
        }
    }
}

