/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public final class InstallChairEvent {
    @SubscribeEvent
    public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Boat boat;
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack mainHandItem = player.getMainHandItem();
        if (target instanceof Boat && (boat = (Boat)target).getPassengers().isEmpty() && mainHandItem.is((Item)InitItems.CHAIR.get())) {
            ServerLevel serverLevel;
            EntityChair spawnChair;
            Level level = player.level;
            if (level instanceof ServerLevel && (spawnChair = ItemChair.getSpawnChair(serverLevel = (ServerLevel)level, player, mainHandItem, target.blockPosition(), target.getXRot())) != null) {
                serverLevel.addFreshEntity((Entity)spawnChair);
                spawnChair.startRiding(target);
                mainHandItem.shrink(1);
            }
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
        }
    }
}

