/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.other;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPicnicBasket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class PicnicBasketContainer
extends AbstractContainerMenu {
    public static final MenuType<PicnicBasketContainer> TYPE = IMenuTypeExtension.create((windowId, inv, data) -> new PicnicBasketContainer(windowId, inv, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)data)));
    private final ItemStack picnicBasket;
    private final ItemStackHandler container;

    public PicnicBasketContainer(int id, Inventory inventory, ItemStack picnicBasket) {
        super(TYPE, id);
        int i;
        this.picnicBasket = picnicBasket;
        this.container = ItemPicnicBasket.getContainer(picnicBasket);
        for (i = 0; i < 9; ++i) {
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.container, i, 8 + i * 18, 18){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return stack.getFoodProperties(null) != null;
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 49 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 107));
        }
    }

    public void clicked(int slotId, int button, ClickType clickTypeIn, Player player) {
        if (slotId == 36 + player.getInventory().selected) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.clicked(slotId, button, clickTypeIn, player);
        ItemPicnicBasket.setContainer(this.picnicBasket, this.container);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack output = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            output = stack.copy();
            if (index < 9 ? !this.moveItemStackTo(stack, 9, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return output;
    }

    public boolean stillValid(Player player) {
        return player.getMainHandItem().getItem() == InitItems.PICNIC_BASKET.get();
    }
}

