/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityEntityPlaceholderRenderer;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class ItemEntityPlaceholder
extends Item {
    public static final IClientItemExtensions ITEM_EXTENSIONS = FMLEnvironment.dist == Dist.CLIENT ? new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            Minecraft minecraft = Minecraft.getInstance();
            return new TileEntityEntityPlaceholderRenderer(minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels());
        }
    } : null;

    public ItemEntityPlaceholder() {
        super(new Item.Properties().stacksTo(1));
    }

    public static ItemStack setRecipeId(ItemStack stack, String id) {
        stack.set(InitDataComponent.RECIPES_ID_TAG, (Object)id);
        return stack;
    }

    @Nullable
    public static ResourceLocation getRecipeId(ItemStack stack) {
        if (stack.has(InitDataComponent.RECIPES_ID_TAG)) {
            return ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)(InitRecipes.ALTAR_CRAFTING.getId().getPath() + "/" + (String)stack.get(InitDataComponent.RECIPES_ID_TAG)));
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getId(ItemStack stack) {
        if (stack.has(InitDataComponent.RECIPES_ID_TAG)) {
            return ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)((String)stack.get(InitDataComponent.RECIPES_ID_TAG)));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillItemCategory(CreativeModeTab.Output items) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        world.getRecipeManager().getAllRecipesFor((RecipeType)InitRecipes.ALTAR_CRAFTING.get()).forEach(recipe -> {
            if (!((AltarRecipe)recipe.value()).isItemCraft()) {
                items.accept(ItemEntityPlaceholder.setRecipeId(new ItemStack((ItemLike)InitItems.ENTITY_PLACEHOLDER.get()), ((AltarRecipe)recipe.value()).getRecipeString()));
            }
        });
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getClickedFace() == Direction.UP) {
            Recipe recipe;
            Optional recipe2;
            ResourceLocation id = ItemEntityPlaceholder.getRecipeId(context.getItemInHand());
            Level world = context.getLevel();
            if (id != null && world instanceof ServerLevel && (recipe2 = context.getLevel().getRecipeManager().byKey(id)).isPresent() && (recipe = ((RecipeHolder)recipe2.get()).value()) instanceof AltarRecipe) {
                AltarRecipe altarRecipe = (AltarRecipe)recipe;
                altarRecipe.spawnOutputEntity((ServerLevel)world, context.getClickedPos().above(), null);
                context.getItemInHand().shrink(1);
            }
        }
        return super.useOn(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName(ItemStack stack) {
        ResourceLocation recipeId = ItemEntityPlaceholder.getId(stack);
        if (recipeId != null) {
            Path path = Paths.get(recipeId.getPath().toLowerCase(Locale.US), new String[0]);
            String langKey = String.format("jei.%s.altar_craft.%s.result", "touhou_little_maid", path.getFileName());
            return Component.translatable((String)langKey);
        }
        return Component.translatable((String)"item.touhou_little_maid.entity_placeholder");
    }
}

