/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.network.message.GomokuServerPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record GomokuClientPackage(BlockPos pos, List<byte[]> chessData, Point point, int count) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GomokuClientPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("gomoku_to_client"));
    public static final StreamCodec<ByteBuf, List<byte[]>> BYTE_BUF_LIST_STREAM_CODEC = ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, (int)15);
    public static final StreamCodec<ByteBuf, GomokuClientPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, GomokuClientPackage::pos, BYTE_BUF_LIST_STREAM_CODEC, GomokuClientPackage::chessData, Point.POINT_STREAM_CODEC, GomokuClientPackage::point, (StreamCodec)ByteBufCodecs.VAR_INT, GomokuClientPackage::count, GomokuClientPackage::new);

    public GomokuClientPackage(BlockPos pos, byte[][] chessData, Point point, int count) {
        this(pos, Arrays.stream(chessData).toList(), point, count);
    }

    public static void handle(GomokuClientPackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> GomokuClientPackage.onHandle(message), Util.backgroundExecutor()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(GomokuClientPackage message) {
        Point aiPoint = MaidGomokuAI.getService(message.count).getPoint((byte[][])message.chessData.toArray((T[])new byte[15][]), message.point);
        int time = (int)(Math.random() * 1250.0) + 250;
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Minecraft.getInstance().submitAsync(() -> PacketDistributor.sendToServer((CustomPacketPayload)new GomokuServerPackage(message.pos, aiPoint), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

